% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_iid_series.R
\name{simulate_iid_brownian_motion}
\alias{simulate_iid_brownian_motion}
\title{Simulate a FTS from a brownian motion process}
\usage{
simulate_iid_brownian_motion(N, v = seq(from = 0, to = 1, length.out =
  100), sig = 1)
}
\arguments{
\item{N}{The number of observations of the simulated data.}

\item{v}{Discretization points of the curves, by default
\code{seq(from = 0, to = 1, length.out = 100)}.}

\item{sig}{Standard deviation of the Brownian Motion process,
by default \code{1}.}
}
\value{
Return the simulated functional time series as a matrix.
}
\description{
Generate a functional time series from a Brownian Motion process.
Each functional observation is discretized in the points
indicated in \code{v}. The series obtained is i.i.d.
and does not exhibit any kind of serial correlation
}
\examples{
N <- 100
v <- seq(from = 0, to = 1, length.out = 20)
sig <- 2
bmotion <- simulate_iid_brownian_motion(N, v, sig)
matplot(v,t(bmotion), type = "l", xlab = "v", ylab = "Value")
}
