% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modified_band_depth.R
\name{modified_band_depth}
\alias{modified_band_depth}
\title{Compute the modified band depth for a sample of curves/functions.}
\usage{
modified_band_depth(dt)
}
\arguments{
\item{dt}{A matrix or data frame of size \eqn{n} functions/curves by \eqn{p} domain/evaluation points.}
}
\value{
A numeric vector of size \code{nrow(dt)} containing the band depth values of each curve.
}
\description{
This function computes the modified band depth of López-Pintado and Romo (2009)\href{https://doi.org/10.1198/jasa.2009.0108}{<doi:10.1198/jasa.2009.0108>}.
Bands of 2 functions are always used and the fast algorithm of Sun et al. (2012)\href{https://doi.org/10.1002/sta4.8}{<doi:10.1002/sta4.8>} is used in computing
the depth values.
}
\examples{
mbd2 <- modified_band_depth(sim_data1$data)

}
\references{
López-Pintado, S., & Romo, J. (2009). On the Concept of Depth for Functional Data.
\emph{Journal of the American Statistical Association}, 104(486), 718-734.

Sun, Y., Genton, M. G., & Nychka, D. W. (2012). Exact fast computation of band depth for large functional datasets:
How quickly can one million curves be ranked?. \emph{Stat}, 1(1), 68-74.
}
