% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateBWPlot.R
\name{CreateBWPlot}
\alias{CreateBWPlot}
\title{Functional Principal Component Analysis Bandwidth Diagnostics plot}
\usage{
CreateBWPlot(fpcaObj, derOptns = NULL, bwMultipliers = NULL)
}
\arguments{
\item{fpcaObj}{An FPCA class object returned by FPCA().}

\item{derOptns}{A list of options to control the derivation parameters; see ?FPCAder. If NULL standard diagnostics are returned}

\item{bwMultipliers}{A vector of multipliers that the original 'bwMu' and 'bwCov' will be multiplied by. (default: c(0.50, 0.75, 1.00, 1.25, 1.50))
- default: NULL}
}
\description{
This function by default creates the mean and first principal modes of variation plots for
50%, 75%, 100%, 125% and 150% of the defined bandwidth choices in the fpcaObj provided as input.
If provided with a derivative options object (?FPCAder) it will return the 
differentiated mean and first two principal modes of variation for 50%, 75%, 100%, 125% and 150% of the defined bandwidth choice.
}
\examples{
set.seed(1)
n <- 40
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res1 <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=FALSE))
CreateBWPlot(res1)
}
