% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateDesignPlot.R
\name{CreateDesignPlot}
\alias{CreateDesignPlot}
\title{Create design plots for functional data. See Yao, F., Müller, H.G., Wang, J.L. (2005). Functional
data analysis for sparse longitudinal data. J. American Statistical Association 100, 577-590
for interpretation and usage of these plots. 
This function will open a new device as default.}
\usage{
CreateDesignPlot(
  Lt,
  obsGrid = NULL,
  isColorPlot = TRUE,
  noDiagonal = TRUE,
  addLegend = TRUE,
  ...
)
}
\arguments{
\item{Lt}{a list of observed time points for functional data}

\item{obsGrid}{a vector of sorted observed time points. Default are the 
unique time points in Lt.}

\item{isColorPlot}{an option for colorful plot: 
TRUE: create color plot with color indicating counts
FALSE: create black and white plot with dots indicating observed time pairs}

\item{noDiagonal}{an option specifying plotting the diagonal design points:
TRUE:  remove diagonal time pairs
FALSE:  do not remove diagonal time pairs}

\item{addLegend}{Logical, default TRUE}

\item{...}{Other arguments passed into \code{plot()}.}
}
\description{
Create design plots for functional data. See Yao, F., Müller, H.G., Wang, J.L. (2005). Functional
data analysis for sparse longitudinal data. J. American Statistical Association 100, 577-590
for interpretation and usage of these plots. 
This function will open a new device as default.
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
CreateDesignPlot(sampWiener$Lt, sort(unique(unlist(sampWiener$Lt))))
}
