% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMeanCI.R
\name{GetMeanCI}
\alias{GetMeanCI}
\title{Bootstrap pointwise confidence intervals for the mean function for densely observed data.}
\usage{
GetMeanCI(Ly, Lt, level = 0.95, R = 999, optns = list())
}
\arguments{
\item{Ly}{A list of n vectors containing the observed values for each individual. 
Missing values specified by \code{NA}s are supported for dense case \code{(dataType='dense')}.}

\item{Lt}{A list of n vectors containing the observation time points for each 
individual corresponding to each element in \code{Ly}. Each vector should be sorted in ascending order.}

\item{level}{A number taking values in [0,1] determing the confidence level. Default: 0.95.}

\item{R}{An integer holding the number of bootstrap replicates. Default: 999.}

\item{optns}{A list of options; see \code{\link{FPCA}} for details.}
}
\value{
A list of two elements: 
\item{CI}{A data frame holding three variables: \code{CIgrid} --- the time grid where the CIs are evaluated; \code{lower} and \code{upper} --- the lower and upper bounds of the CIs on \code{CIgrid}.}
\item{level}{The confidence level of the CIs}.
}
\description{
Note that bootstrap pointwise confidence intervals do not work for sparsely observed data.
}
\examples{
n <- 30
tgrid <- seq(0,1,length.out=21)
phi1 <- function(t) sqrt(2)*sin(2*pi*t)
phi2 <- function(t) sqrt(2)*sin(4*pi*t)
Lt <- rep(list(tgrid), n)
Ly <- lapply(1:n, function(i){
 tgrid + rnorm(1,0,2) * phi1(tgrid) + rnorm(1,0,0.5) * phi2(tgrid) + rnorm(1,0,0.01)
 })
res <- GetMeanCI(Lt = Lt, Ly = Ly, level = 0.9)
}
