% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongRunCovMatrix.R
\name{LongRunCovMatrix}
\alias{LongRunCovMatrix}
\title{Long Run Covariance Matrix Estimation for Multivariate Time Series}
\usage{
LongRunCovMatrix(mdobj, h = 0, kern_type = "bartlett")
}
\arguments{
\item{mdobj}{A multivariate data object}

\item{h}{The bandwidth parameter. It is strictly non-zero. Choosing the bandwidth parameter to be zero is identical
to estimating covariance matrix assuming iid data.}

\item{kern_type}{Kernel function to be used for the estimation of the long run covariance
matrix. The choices are \code{c("BT", "PR", "SP", "FT")} which are respectively, bartlett, parzen, simple and flat-top kernels.
By default the function uses a \code{"barlett"} kernel.}
}
\value{
Returns long run covariance matrix
}
\description{
This function estimates the long run covariance matrix of a given multivariate data sample.
}
