% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{LINREG}
\alias{LINREG}
\title{Linear Regression}
\usage{
LINREG(
  x,
  y,
  formula = ".",
  reg = c("linear", "subset", "ridge", "lasso", "elastic", "pcr", "plsr"),
  regeval = c("r2", "bic", "adjr2", "cp", "msep"),
  scale = TRUE,
  lambda = 10^seq(-5, 5, length.out = 101),
  alpha = 0.5,
  graph = TRUE,
  tune = FALSE,
  ...
)
}
\arguments{
\item{x}{Predictor \code{matrix}.}

\item{y}{Response \code{vector}.}

\item{formula}{A symbolic description of the model to be fitted (as a character string).}

\item{reg}{The algorithm.}

\item{regeval}{The evaluation criterion for subset selection.}

\item{scale}{If true, PCR and PLS use scaled dataset.}

\item{lambda}{The lambda parameter of Ridge, Lasso and Elastic net regression.}

\item{alpha}{The elasticnet mixing parameter.}

\item{graph}{A logical indicating whether or not graphics should be plotted (ridge, LASSO and elastic net).}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other parameters.}
}
\value{
The classification model, as an object of class \code{\link{model-class}}.
}
\description{
This function builds a linear regression model.
Standard least square method, variable selection, factorial methods are available.
}
\examples{
\dontrun{
require (datasets)
# With one independant variable
data (cars)
LINREG (cars [, -2], cars [, 2])
# With two independant variables
data (trees)
LINREG (trees [, -3], trees [, 3])
# With non numeric variables
data (ToothGrowth)
LINREG (ToothGrowth [, -1], ToothGrowth [, 1], formula = "-1+supp+dose") # Different intersept
LINREG (ToothGrowth [, -1], ToothGrowth [, 1], formula = "dose:supp") # Different slope
LINREG (ToothGrowth [, -1], ToothGrowth [, 1], formula = "-1+supp+dose:supp") # Complete model
# With multiple numeric variables
data (mtcars)
LINREG (mtcars [, -1], mtcars [, 1])
LINREG (mtcars [, -1], mtcars [, 1], reg = "subset", regeval = "adjr2")
LINREG (mtcars [, -1], mtcars [, 1], reg = "ridge")
LINREG (mtcars [, -1], mtcars [, 1], reg = "lasso")
LINREG (mtcars [, -1], mtcars [, 1], reg = "elastic")
LINREG (mtcars [, -1], mtcars [, 1], reg = "pcr")
LINREG (mtcars [, -1], mtcars [, 1], reg = "plsr")
}
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[leaps]{regsubsets}}, \code{\link[pls]{mvr}}, \code{\link[glmnet]{glmnet}}
}
