% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{treeplot}
\alias{treeplot}
\title{Dendrogram Plots}
\usage{
treeplot(clustering, labels = FALSE, k = NULL, ...)
}
\arguments{
\item{clustering}{The dendrogram to be plotted (result of \code{\link[stats]{hclust}}, \code{\link[cluster]{agnes}} or \code{\link{HCA}}).}

\item{labels}{Indicates whether or not labels (row names) should be showned on the plot.}

\item{k}{Number of clusters. If not specified an "optimal" value is determined.}

\item{...}{Other parameters.}
}
\description{
Draws a dendrogram.
}
\examples{
require (datasets)
data (iris)
hca = HCA (iris [, -5], method = "ward", k = 3)
treeplot (hca)
}
\seealso{
\code{\link[stats]{dendrogram}}, \code{\link{HCA}}, \code{\link[stats]{hclust}}, \code{\link[cluster]{agnes}}
}
