% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{intern.dunn}
\alias{intern.dunn}
\title{Clustering evaluation through Dunn's index}
\usage{
intern.dunn(clus, d, type = c("global"))
}
\arguments{
\item{clus}{The extracted clusters.}

\item{d}{The dataset.}

\item{type}{Indicates whether a "global" or a "cluster"-wise evaluation should be used.}
}
\value{
The evaluation of the clustering.
}
\description{
Evaluation a clustering algorithm according to Dunn's index.
}
\examples{
require (datasets)
data (iris)
km = KMEANS (iris [, -5], k = 3)
intern.dunn (km$clus, iris [, -5])
}
\seealso{
\code{\link{intern}}, \code{\link{intern.interclass}}, \code{\link{intern.intraclass}}
}
