% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf.R
\name{ACF}
\alias{ACF}
\alias{PACF}
\alias{CCF}
\title{(Partial) Autocorrelation and Cross-Correlation Function Estimation}
\usage{
ACF(.data, ..., lag_max = NULL, demean = TRUE,
  type = c("correlation", "covariance", "partial"))

PACF(.data, ..., lag_max = NULL)

CCF(.data, ..., lag_max = NULL, type = c("correlation", "covariance"))
}
\arguments{
\item{.data}{A tsibble}

\item{...}{The column(s) from the tsibble used to compute the ACF, PACF or CCF.}

\item{lag_max}{maximum lag at which to calculate the acf. Default is 10*log10(N/m)
where N is the number of observations and m the number of series. Will be
automatically limited to one less than the number of observations in the series.}

\item{demean}{logical.  Should the covariances be about the sample
    means?}

\item{type}{character string giving the type of acf to be computed.
    Allowed values are
    \code{"correlation"} (the default), \code{"covariance"} or
    \code{"partial"}.  Will be partially matched.}
}
\value{
The \code{ACF}, \code{PACF} and \code{CCF} functions return objects
of class "tbl_cf", which is a tsibble containing the correlations computed.
}
\description{
The function \code{ACF} computes an estimate of the autocorrelation function
of a (possibly multivariate) tsibble. Function \code{PACF} computes an estimate
of the partial autocorrelation function of a (possibly multivariate) tsibble.
Function \code{CCF} computes the cross-correlation or cross-covariance of two columns
from a tsibble.
}
\details{
The functions improve the \code{\link[stats]{acf}},
\code{\link[stats]{pacf}} and \code{\link[stats]{ccf}} functions. The main
differences are that \code{ACF} does not plot a spike at lag 0 when
\code{type=="correlation"} (which is redundant) and the horizontal axes show
lags in time units rather than seasonal units.

The resulting tables from these functions can also be plotted using
\code{\link[=autoplot.tbl_cf]{autoplot.tbl_cf()}}.
}
\examples{
library(tsibble)
library(tsibbledata)
library(dplyr)

vic_elec \%>\% ACF(Temperature)

vic_elec \%>\% ACF(Temperature) \%>\% autoplot()

vic_elec \%>\% PACF(Temperature)

vic_elec \%>\% PACF(Temperature) \%>\% autoplot()

global_economy \%>\%
  filter(Country == "Australia") \%>\%
  CCF(GDP, Population)

global_economy \%>\%
  filter(Country == "Australia") \%>\%
  CCF(GDP, Population) \%>\%
  autoplot()

}
\references{
Hyndman, R.J. (2015). Discussion of ``High-dimensional
autocovariance matrices and optimal linear prediction''. \emph{Electronic
Journal of Statistics}, 9, 792-796.

McMurry, T. L., & Politis, D. N. (2010). Banded and tapered estimates for
autocovariance matrices and the linear process bootstrap. \emph{Journal of
Time Series Analysis}, 31(6), 471-482.
}
\seealso{
\code{\link[stats]{acf}}, \code{\link[stats]{pacf}},
\code{\link[stats]{ccf}}
}
\author{
Mitchell O'Hara-Wild and Rob J Hyndman
}
