% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-mks-test.R
\name{eda_mks_test}
\alias{eda_mks_test}
\title{Mann–Kendall–Sneyers Test for Change Point Detection}
\usage{
eda_mks_test(data, years, alpha = 0.05)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{years}: The \code{years} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{progressive_series}: Normalized progressive Mann–Kendall-Sneyers statistics.
\item \code{regressive_series}: Normalized regressive Mann–Kendall-Sneyers statistics.
\item \code{bound}: Critical confidence bound for significance based on \code{alpha}.
\item \code{change_points}: A dataframe of potential change points.
\item \code{p_value}: Two-sided p-value of the most significant crossing point.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}

\code{change_points} contains the years, test statistics, and p-values of each
potential change point. If no change points were identified, \code{change_points}
is empty.
}
\description{
Performs the Mann–Kendall–Sneyers (MKS) test to detect a trend change in annual
maximum series data. The test computes normalized progressive and regressive
Mann–Kendall statistics and identifies statistically significant crossing points,
indicating potential change points. Under the null hypothesis, there are no trend
changes.
}
\details{
This function computes progressive and regressive Mann–Kendall-Sneyers statistics,
normalized by their expected values and variances under the null hypothesis. The
crossing points occur when the difference between the progressive and regressive
statistics switches sign. The significance of detected crossing points is assessed
using the quantiles of the normal distribution.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
eda_mks_test(data, years)

}
\references{
Sneyers, R. (1990). On the statistical analysis of series of observations.
Technical note No. 143, World Meteorological Organization, Geneva.
}
\seealso{
\code{\link[=plot_mks_test]{plot_mks_test()}}, \code{\link[=eda_pettitt_test]{eda_pettitt_test()}}
}
