% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teams.R
\name{league_teams}
\alias{league_teams}
\title{Fantasy league teams}
\usage{
league_teams(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}
(e.g., \code{scoringPeriodId}). Arguments are converted to a named list to be
passed alongside \code{view}.}
}
\value{
A dataframe (or list) with league teams.
}
\description{
The teams in a league and their owners.
}
\examples{
league_teams(leagueId = "42654852")
}
\seealso{
Other League information: 
\code{\link{league_members}()}
}
\concept{League information}
