% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myorth.R
\name{myorth}
\alias{myorth}
\alias{myrank}
\title{Rank and orthonormal basis}
\usage{
myorth(X, tol_ = 1e-09)
}
\arguments{
\item{X}{numeric matrix.}

\item{tol_}{tuning parameter for the rank.}
}
\value{
\code{myorth} returns a matrix, whose columns form an orthonormal
basis.

\code{myrank} returns a single number, which is the rank of \code{X}.
}
\description{
\code{myorth(X)} makes an orthonormal basis for the space spanned by the
columns of \code{X}. The number of columns returned equals \code{myrank(X)},
which is the rank of \code{X}.
}
\details{
The calculations are based on the singular value decomposition
(\code{\link{svd}}). And \code{myrank(X)} is the number of singular values
of \code{X} that are larger than \code{max(dim(X))*svd(x)$d[1]*tol_}.
}
\note{
In the special case where \code{X} has a single column,
\code{myorth(X)} returns \code{c*X} where \code{c} is a positive constant.
}
\seealso{
\code{\link{svd}}
}
\author{
Øyvind Langsrud and Bjørn-Helge Mevik
}
\keyword{algebra}
\keyword{array}
\keyword{internal}
