% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norway_thredds.R
\docType{data}
\name{senorge}
\alias{senorge}
\title{1x1km grids to Norwegian municipalities}
\format{\describe{
\item{row}{The row of the [X,Y,time] matrix.}
\item{col}{The column of the [X,Y,time] matrix.}
\item{location_code}{Municipality code that this 1x1km grid belongs to.}
\item{year}{The year that location_code corresponds to.}
}}
\source{
\url{http://thredds.met.no/thredds/catalog/senorge/seNorge_2018/Archive/catalog.html}
}
\usage{
senorge
}
\description{
We classify the 1x1km grids from senorge into municipalities.
}
\examples{
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat, group = group))
q <- q + geom_polygon(data = fhidata::norway_map_municips, color = "black")
q <- q + theme_void()
q <- q + coord_quickmap()
q
}
\keyword{datasets}
