% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_rm_indices}
\alias{fhir_rm_indices}
\title{Remove indices from data frame}
\usage{
fhir_rm_indices(indexed_data_frame, brackets = c("<", ">"), sep = "-+-")
}
\arguments{
\item{indexed_data_frame}{A data frame with indices for multiple entries as produced by \code{\link{fhir_crack}}}

\item{brackets}{A character of length two defining the brackets that were used in \code{\link{fhir_crack}}}

\item{sep}{A string defining the separator that was used when pasting together multiple entries in \code{\link{fhir_crack}}}
}
\value{
A data frame without indices.
}
\description{
Removes the indices produced by \code{\link{fhir_crack}} when \code{add_indices=TRUE}
}
\examples{



bundle <- xml2::read_xml(
"<Bundle>

        <Patient>
            <id value='id1'/>
            <address>
                <use value='home'/>
                <city value='Amsterdam'/>
                <type value='physical'/>
               <country value='Netherlands'/>
            </address>
            <birthDate value='1992-02-06'/>
        </Patient>

        <Patient>
            <id value='id2'/>
            <address>
                <use value='home'/>
                <city value='Rome'/>
                <type value='physical'/>
                <country value='Italy'/>
            </address>
            <address>
                <use value='work'/>
                <city value='Stockholm'/>
                <type value='postal'/>
                <country value='Sweden'/>
            </address>
            <birthDate value='1980-05-23'/>
        </Patient>
</Bundle>"
)


dfs <- fhir_crack(bundles = list(bundle), design = list(Patients = list("/Bundle/Patient")),
                  add_indices = TRUE, verbose = 2)

df_indices_removed <- fhir_rm_indices(dfs[[1]])
}
