% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_maltipoo.R
\name{maltipoo_fit}
\alias{maltipoo_fit}
\alias{maltipoo}
\title{Interface to fit maltipoo models}
\usage{
maltipoo(
  Y = NULL,
  X = NULL,
  upsilon = NULL,
  Theta = NULL,
  U = NULL,
  Xi = NULL,
  init = NULL,
  ellinit = NULL,
  pars = c("Eta", "Lambda", "Sigma"),
  ...
)
}
\arguments{
\item{Y}{D x N matrix of counts (if NULL uses priors only)}

\item{X}{Q x N matrix of covariates (design matrix) (if NULL uses priors only, must
be present to sample Eta)}

\item{upsilon}{dof for inverse wishart prior (numeric must be > D)
(default: D+3)}

\item{Theta}{(D-1) x Q matrix of prior mean for regression parameters
(default: matrix(0, D-1, Q))}

\item{U}{a PQ x Q matrix of stacked variance components (each of dimension Q x Q)}

\item{Xi}{(D-1)x(D-1) prior covariance matrix
(default: ALR transform of diag(1)*(upsilon-D)/2 - this is
essentially iid on "base scale" using Aitchison terminology)}

\item{init}{(D-1) x Q initialization for Eta for optimization}

\item{ellinit}{P vector initialization values for ell for optimization}

\item{pars}{character vector of posterior parameters to return}

\item{...}{arguments passed to \code{\link{optimPibbleCollapsed}} and
\code{\link{uncollapsePibble}}}
}
\value{
an object of class maltipoofit
}
\description{
This function is largely a more user friendly wrapper around 
\code{\link{optimMaltipooCollapsed}} and 
\code{\link{uncollapsePibble}}. 
See details for model specification. 
 Notation: \code{N} is number of samples,
 \code{D} is number of multinomial categories, \code{Q} is number
 of covariates, \code{P} is the number of variance components 
 \code{iter} is the number of samples of \code{eta} (e.g.,
 the parameter \code{n_samples} in the function 
 \code{\link{optimPibbleCollapsed}})
}
\details{
the full model is given by:
   \deqn{Y_j \sim Multinomial(Pi_j)}
   \deqn{Pi_j = Phi^{-1}(Eta_j)}
   \deqn{Eta \sim MN_{D-1 x N}(Lambda*X, Sigma, I_N)}
   \deqn{Lambda \sim MN_{D-1 x Q}(Theta, Sigma, Gamma)}
   \deqn{Gamma = e^{ell_1} U_1 + ... + e^{ell_P} U_P}
   \deqn{Sigma \sim InvWish(upsilon, Xi)}
   
 Where A = (I_N + X * Gamma * X')^{-1}, K^{-1} = Xi is a (D-1)x(D-1) 
 covariance matrix, U_1 is a Q x Q covariance matrix (a variance component), 
 e^{ell_i} is a scale for that variance component and Phi^{-1} is 
 ALRInv_D transform. 
 
 Default behavior is to use MAP estimate for uncollaping collapsed maltipoo 
 model if laplace approximation is not preformed. 
 
 Parameters ell are treated as fixed and estimated by MAP estimation.
}
