% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccLabel.R
\name{ccLabel}
\alias{ccLabel}
\title{ccLabel}
\usage{
ccLabel(x, method = "simple", change.threshold = NULL)
}
\arguments{
\item{x}{Object of class \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick}.}

\item{method}{Labeling method. Choose between 'simple' and 'change'. Default is 'simple'.}

\item{change.threshold}{Numeric element.}
}
\value{
A list.
}
\description{
Labels groups of pixels in a raster object that share similar attributes.
}
\details{
{Uses a 8-neighbor connected component labeling algorithm (determined by \emph{method}) to identify groups of pixels of the same
value. Each group receives a distinct numeric label. The function provides two connected component labeling algorithms:
\itemize{
 \item{\emph{simple} - Connects neighboring pixels with the same value. Suitable for categorical data.}
 \item{\emph{spatial} - Estimates the MAPE using a 3x3 moving window distinguishes neighboring pixels 
 when the spatial change is lower than \emph{change.threshold}.}
 \item{\emph{temporal} - Estimates the MAPE among all bands in a raster object and distinguishes spatially 
 neighboring pixels when the temporal change is higher than \emph{change.threshold}.}}
The final output of the function is a list consisting of:
\itemize{
 \item{\emph{regions} - \emph{RasterLayer} object with region labels.}
 \item{\emph{frequency} - \emph{data.frame} object with the pixel count for each unique value in \emph{regions}.}}}
}
\examples{
{

require(raster)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# spatial change labeling
or <- ccLabel(r[[1]], method="spatial", change.threshold=10)
plot(or$regions)

# temporal change labeling
or <- ccLabel(r, method="temporal", change.threshold=80)
plot(or$regions)

}
}
\seealso{
\code{\link{classModel}} \code{\link{rankPlots}}
}
