% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster2sample.R
\name{raster2sample}
\alias{raster2sample}
\title{raster2sample}
\usage{
raster2sample(x)
}
\arguments{
\item{x}{Object of class \emph{SpatialPolygons} or \emph{SpatialPolygonDataFrame}.}
}
\value{
A \emph{SpatialPointsDataFrame} with sampled pixels reporting on pixel compactness.
}
\description{
{Converts a raster grid to points.}
}
\details{
{\emph{poly2Sample} extends on the \code{\link[raster]{rasterToPoints}} function from the raster package. For 
each non-NA pixel in \emph{x}, the function will use 3x3 moving window and report on the frequency of non-NA pixels. 
This can be useful to identify "pure" samples within a clump of pixels (i.e. high frequency) as well as mixed pixels 
along their borders (i.e. low frequency). The output is a \emph{SpatialPointsDataFrame} reporting on:
\itemize{
 \item{\emph{x} - x coordinate.}
 \item{\emph{y} - y coordinate.}
 \item{\emph{cover} - Non-NA value frequency.}
 \item{\emph{id} - Corresponding raster value in \emph{x}.}}}
}
\examples{
{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'probabilities.tif', package="rsMove")
 img <- raster(file) > 0.5
 img[img != 1] <- NA
 
 # extract samples
 samples <- raster2sample(img)

}
}
\seealso{
\link[rsMove]{poly2sample} \code{\link{ccLabel}}
}
