% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-extract-non-nums.R
\name{extract_non_numerics}
\alias{extract_non_numerics}
\alias{nth_non_numeric}
\alias{first_non_numeric}
\alias{last_non_numeric}
\title{Extract non-numbers from a string.}
\usage{
extract_non_numerics(string, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE)

nth_non_numeric(string, n, decimals = FALSE, leading_decimals = FALSE,
  negs = FALSE)

first_non_numeric(string, decimals = FALSE, leading_decimals = FALSE,
  negs = FALSE)

last_non_numeric(string, decimals = FALSE, leading_decimals = FALSE,
  negs = FALSE)
}
\arguments{
\item{string}{A string.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{n}{The index of the number (or non-numeric) that you seek. Negative
indexing is allowed i.e. \code{n = 1} (the default) will give you the first
number (or non-numeric) whereas \code{n = -1} will give you the last number (or
non-numeric), \code{n = -2} will give you the second last number and so on. The
function is vectorized over this argument.}
}
\description{
See \code{\link[strex:str_extract_non_numerics]{strex::str_extract_non_numerics()}}
}
