% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_senate_sessions.R
\name{get_senate_sessions}
\alias{get_senate_sessions}
\title{Start and end dates of Senate sessions}
\usage{
get_senate_sessions()
}
\value{
A tibble with the \code{begin_date} and \code{adjourn_date} of each
session of the Senate.
}
\description{
\code{get_senate_sessions()} returns a tibble with the beginning (convening) and
ending (adjournment) dates of each legislative session of the Senate.
}
\details{
The data is sourced from the official Senate website, specifically
\url{https://www.senate.gov/legislative/DatesofSessionsofCongress.htm}.

\strong{Senate sessions explained}

That webpage provides this explanation of Senate sessions:

\emph{Prior to the 74th Congress (1935-1937), the first session of a Congress
officially began on March 4 of odd-numbered years and ended at midnight
on March 3 of odd-numbered years. Since 1935, in accordance with the
20th Amendment to the Constitution, Congresses have begun and ended at noon
on January 3 of odd-numbered years. Each two-year Congress typically
includes two legislative sessions, although third or special sessions were
common in earlier years.}

\strong{The \code{session} column}

The \code{session} column is type factor, with the following levels:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{levels(get_senate_sessions()$session)
#> [1] "1" "2" "3" "4" "S"
# Note: That's a letter S, not a number 5!
}\if{html}{\out{</div>}}

The Senate has had just 2 sessions in each Congress since 1941, so if you
are just working with more recent data, you could convert this column to
numeric. However, if you are working with pre-1941 data, you will likely
be dealing with special sessions (denoted \code{"S"}), not just numbered
sessions.
}
\examples{
\dontshow{if (!is.null(curl::nslookup("www.senate.gov", error = FALSE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_senate_sessions()
\dontshow{\}) # examplesIf}
}
