% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_label.R
\name{ff_relabel}
\alias{ff_relabel}
\alias{finalfit_relabel}
\title{Relabel variables in a data frame}
\usage{
ff_relabel(.data, .labels)

finalfit_relabel(.data, .labels)
}
\arguments{
\item{.data}{Data frame to be relabelled}

\item{.labels}{Vector of variable labels (usually created using
\code{\link{extract_variable_label}}) of same length as \code{.data}.}
}
\description{
Variable labels can be created using \code{\link{ff_label}}. Some functions
strip variable labels (variable attributes), e.g. \code{forcats::fct_recode}.
Use this function to create a vector of variable labels from a data frame.
Then use \code{\link{ff_relabel}} to relabel variables in data frame.
}
\examples{
# Label variable
colon_s$sex.factor \%>\%
  ff_label("Sex") \%>\%
  str()

# Make factor level "Unknown" NA
colon_s \%>\%
  dplyr::mutate_if(is.factor, forcats::fct_recode, 
  NULL = "Unknown") \%>\% 
  str()

# Reset data
data(colon_s)

# Extract variable labels
vlabels = colon_s \%>\% extract_variable_label()

# Run function where labels are lost
colon_s \%>\%
  dplyr::mutate_if(is.factor, forcats::fct_recode, 
  NULL = "Unknown") \%>\% 
  str()

# Relabel
colon_s \%<>\% ff_relabel(vlabels)
colon_s \%>\% str()
  
}
