% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{FCRN_received_bids_hourly_market}
\alias{FCRN_received_bids_hourly_market}
\title{Frequency containment reserves for normal operation, received bids in hourly market}
\usage{
FCRN_received_bids_hourly_market(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the volume of received Frequency
Containment Reserves for Normal operation (FCR-N) bids. The volume of
bids will be published 22:45 (EET) on previous evening.
}
\description{
Check https://data.fingrid.fi/en/dataset/taajuusohjattu-kayttoreservi-tarjousmaarat-tuntimarkkinoilta
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- FCRN_received_bids_hourly_market(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
