% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHGbeta.R
\name{fitGHGBB}
\alias{fitGHGBB}
\title{Fitting the Gaussian Hypergeometric Generalized Beta  Binomial Distribution when binomial
random variable, frequency and shape parameters a,b and c are given}
\usage{
fitGHGBB(x,obs.freq,a,b,c)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing a.}

\item{b}{single value for shape parameter beta representing b.}

\item{c}{single value for shape parameter lambda representing c.}
}
\value{
The output of \code{fitGHGBB} gives the class format \code{fitGB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitGB} fitted values of \code{dGHGBB}.

\code{NegLL} Negative Loglikelihood value.

\code{a} estimated value for alpha parameter as a.

\code{b} estimated value for beta parameter as b.

\code{c} estimated value for gamma parameter as c.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted} can be used
to extract specific outputs.
}
\description{
The function will fit the Gaussian Hypergeometric Generalized Beta Binomial Distribution
when random variables, corresponding frequencies and shape parameters are given. It will provide
the expected frequencies, chi-squared test statistics value, p value, degree of freedom
and over dispersion value so that it can be seen if this distribution fits the data.
}
\details{
\deqn{0 < a,b,c}
\deqn{x = 0,1,2,...}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7        #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)       #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEGHGBB(No.D.D,Obs.fre.1,0.1,20,1.3)

bbmle::coef(parameters)         #extracting the parameters
aGHGBB <- bbmle::coef(parameters)[1]  #assigning the estimated a
bGHGBB <- bbmle::coef(parameters)[2]  #assigning the estimated b
cGHGBB <- bbmle::coef(parameters)[3]  #assigning the estimated c

#fitting when the random variable,frequencies,shape parameter values are given.
results <- fitGHGBB(No.D.D,Obs.fre.1,aGHGBB,bGHGBB,cGHGBB)
results

#extracting the expected frequencies
fitted(results)

#extracting the residuals
residuals(results)

}
\references{
Rodriguez-Avi, J., Conde-Sanchez, A., Saez-Castillo, A. J., & Olmo-Jimenez, M. J. (2007). A generalization
of the beta-binomial distribution. Journal of the Royal Statistical Society. Series C (Applied Statistics), 56(1), 51-61.

Available at : \url{http://dx.doi.org/10.1111/j.1467-9876.2007.00564.x}

Pearson, J., 2009. Computation of Hypergeometric Functions. Transformation, (September), p.1--123.
}
\seealso{
\code{\link[hypergeo]{hypergeo_powerseries}}

--------------------

\code{\link[bbmle]{mle2}}
}
