% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{EstMLEGammaBin}
\alias{EstMLEGammaBin}
\title{Estimating the shape parameters c and l for Gamma Binomial distribution}
\usage{
EstMLEGammaBin(x,freq,c,l,...)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{c}{single value for shape parameter c.}

\item{l}{single value for shape parameter l.}

\item{...}{mle2 function inputs except data and estimating parameter.}
}
\value{
\code{EstMLEGammaBin} here is used as a wrapper for the \code{mle2} function of \pkg{bbmle} package
therefore output is of class of mle2.
}
\description{
The function will estimate the shape parameters using the maximum log likelihood method
for the Gamma Binomial distribution when the binomial random variables and corresponding frequencies
are given.
}
\details{
\deqn{0 < c,l}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7                   #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEGammaBin(x=No.D.D,freq=Obs.fre.1,c=0.1,l=0.1)

bbmle::coef(parameters)         #extracting the parameters

}
\references{
Grassia, A., 1977. On a family of distributions with argument between 0 and 1
obtained by transformation of the gamma and derived compound distributions.
Australian Journal of Statistics, 19(2), pp.108-114.
}
