% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHGbeta.R
\name{NegLLGHGBB}
\alias{NegLLGHGBB}
\title{Negative Log Likelihood value of Gaussian Hypergeometric Generalized Beta Binomial Distribution}
\usage{
NegLLGHGBB(x,freq,a,b,c)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing a.}

\item{b}{single value for shape parameter beta representing b.}

\item{c}{single value for shape parameter lambda representing c.}
}
\value{
The output of \code{NegLLGHGBB} will produce a single numeric value.
}
\description{
This function will calculate the negative log likelihood value when the vector of binomial random
variables and vector of corresponding frequencies are given with the shape parameters a,b and c.
}
\details{
\deqn{0 < a,b,c }
\deqn{freq \ge 0}
\deqn{x = 0,1,2,...}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7                    #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)     #assigning the corresponding frequencies
NegLLGHGBB(No.D.D,Obs.fre.1,.2,.3,1)     #acquiring the negative log likelihood value

}
\references{
Rodriguez-Avi, J., Conde-Sanchez, A., Saez-Castillo, A. J., & Olmo-Jimenez, M. J. (2007). A generalization
of the beta-binomial distribution. Journal of the Royal Statistical Society. Series C (Applied Statistics), 56(1), 51-61.


Pearson, J., 2009. Computation of Hypergeometric Functions. Transformation, (September), p.1--123.
}
\seealso{
\code{\link[hypergeo]{hypergeo_powerseries}}
}
