% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-player-stats.R
\name{fetch_player_stats}
\alias{fetch_player_stats}
\alias{fetch_player_stats_afl}
\alias{fetch_player_stats_afltables}
\alias{fetch_player_stats_fryzigg}
\alias{fetch_player_stats_footywire}
\title{Fetch Player Stats}
\usage{
fetch_player_stats(
  season = NULL,
  round_number = NULL,
  comp = "AFLM",
  source = "AFL",
  ...
)

fetch_player_stats_afl(season = NULL, round_number = NULL, comp = "AFLM")

fetch_player_stats_afltables(season = NULL, round_number = NULL)

fetch_player_stats_fryzigg(season = NULL, round_number = NULL, comp = "AFLM")

fetch_player_stats_footywire(
  season = NULL,
  round_number = NULL,
  check_existing = TRUE
)
}
\arguments{
\item{season}{Season in YYYY format, defaults to NULL which returns the year
corresponding the \code{Sys.Date()}}

\item{round_number}{Round number, defaults to NULL which returns latest round}

\item{comp}{One of "AFLM" (default) or "AFLW"}

\item{source}{One of "AFL" (default), "footywire", "fryzigg", "afltables", "squiggle"}

\item{...}{Optional parameters passed onto various functions depending on source.}

\item{check_existing}{logical, should we check existing data. This will likely be removed in future version as it takes a long time to re-scrape data}
}
\value{
A Tibble with the player stats from the relevant \code{season} and \code{round}.
}
\description{
\code{fetch_player_stats} returns the Individual Player Statistics for AFL games. Internally, it calls
a corresponding \verb{fetch_player_stats_*} function that depends on the source given.
By default the source used will be the official AFL website.

\code{\link[=fetch_player_stats_footywire]{fetch_player_stats_footywire()}}, \code{\link[=fetch_player_stats_afltables]{fetch_player_stats_afltables()}}, \code{\link[=fetch_player_stats_fryzigg]{fetch_player_stats_fryzigg()}}
can be called directly and return data from AFL website, AFL Tables and
Squiggle, respectively.
}
\examples{
\dontrun{
# Return data for whole season from footywire
fetch_player_stats(source = "footywire")

# This is equivalent to
fetch_player_stats_footywire()

# Currently there is no AFLW data and will return a warning
fetch_player_stats(2020, comp = "AFLW", source = "footywire")

# Different sources
fetch_player_stats(2015, round = 5, source = "footywire")
fetch_player_stats(2015, round = 5, source = "fryzigg")

# Directly call functions for each source
fetch_player_stats_afltables(2020)
fetch_fixture_fryzigg(2020)
fetch_player_stats_footywire(2020)
}

}
\seealso{
\itemize{
\item \link{fetch_player_stats_footywire} for Footywire data.
\item \link{fetch_player_stats_afltables} for AFL Tables data.
\item \link{fetch_player_stats_fryzigg} for Fryzigg data.
}

Other fetch fixture functions: 
\code{\link{fetch_fixture}()}
}
\concept{fetch fixture functions}
