% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{lag.formula}
\alias{lag.formula}
\title{Lags a variable using a formula}
\usage{
\method{lag}{formula}(x, k, data, time.step = "unitary", fill = NA,
  duplicate.method = c("none", "first"), ...)
}
\arguments{
\item{x}{A formula of the type \code{var ~ id + time} where \code{var} is the variable to be lagged, \code{id} is a variable representing the panel id, and \code{time} is the time variable of the panel.}

\item{k}{An integer giving the number of lags. For leads, just use a negative number.}

\item{data}{Optional, the data.frame in which to evaluate the formula.}

\item{time.step}{The method to compute the lags. Can be equal to: \code{"unitary"} (default), \code{"consecutive"} or to a number. If \code{"unitary"}, then the largest common divisor between consecutive time periods is used (typically if the time variable represents years, it will be 1). This method can apply only to integer (or convertible to integer) variables. If \code{"consecutive"}, then the time variable can be of any type: two successive time periods represent a lag of 1. Finally, if the time variable is numeric, you can provide your own numeric time step.}

\item{fill}{How to fill the observations without defined lead/lag values. Default is \code{NA}.}

\item{duplicate.method}{If several observations have the same id and time values, then the notion of lag is not defined for them. If \code{duplicate.method = "none"} (default) and duplicate values are found, this leads to an error. You can use \code{duplicate.method = "first"} so that the first occurrence of identical id/time observations will be used as lag.}

\item{...}{Not currently used.}
}
\value{
It returns a vector of the same type and length as the variable to be lagged in the formula.
}
\description{
Lags a variable using panel id+time identifiers in a formula.
}
\examples{
# simple example with an unbalanced panel
base = data.frame(id = rep(1:2, each = 4),
                  time = c(1, 2, 3, 4, 1, 4, 6, 9), x = 1:8)

lag(x~id+time,  1, base) # lag 1
lag(x~id+time, -1, base) # lead 1

lag(x~id+time, 2, base, fill = 0)

# with time.step = "consecutive"
lag(x~id+time, 1, base, time.step = "cons")
# => works for indiv. 2 because 9 (resp. 6) is consecutive to 6 (resp. 4)
# mostly useful when the time variable is not a number:
# e.g. c("1991q1", "1991q2", "1991q3") etc

# with duplicates
base_dup = data.frame(id = rep(1:2, each = 4),
                      time = c(1, 1, 1, 2, 1, 2, 2, 3), x = 1:8)

# by default: error
\donttest{
lag(x~id+time, 1, base_dup)
}
# with duplicate.method = "first"
lag(x~id+time, 1, base_dup, duplicate.method = "first")

\donttest{
# You can create variables without specifying the data within data.table:
library(data.table)
base = data.table(id = rep(1:2, each = 3), year = 1990 + rep(1:3, 2), x = 1:6)
base[, x.l1 := lag(x~id+year, 1)]
}


}
\author{
Laurent Berge
}
