% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{fittedTrtEff}
\alias{fittedTrtEff}
\title{Fitted treatment effect values from Reversible Jump MCMC (rjMCMC) Model Results}
\usage{
fittedTrtEff(results, newdata = NULL)
}
\arguments{
\item{results}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, including posterior samples and fitted splines.}

\item{newdata}{A data frame for which fitted values are to be computed. If NA, the original fitted data is used.}
}
\value{
A matrix of fitted values.
}
\description{
This function generates posterior fitted treatment effects from an rjMCMC model based on the provided data.
It combines the fixed effects, spline terms, and binary parameters.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

mcmc_specs <- list(B = 2000, burnin = 1000, thin = 1, chains = 2, sigma_v = 0.1, bma = TRUE)
prior_params <- list(lambda_1 = 0.1, lambda_2 = 1, a_0 = 0.01, b_0 = 0.01,
                  degree = 3, k_max = 9, w = 1, sigma_B = sqrt(20))

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  mcmc_specs, prior_params)
newdata = data.frame(Z_1 = 1, Z_2 = 1, Z_3 = 1, Z_4 = 1, Z_5 = 1,
                   trt = 1, X_1 = seq(0,1,by=0.01))
fittedTrtEff(results)
fittedTrtEff(results,newdata)
}
}
