% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_recode.R
\name{light_recode}
\alias{light_recode}
\alias{light_recode.default}
\alias{light_recode.light}
\title{Recode Factor Columns}
\usage{
light_recode(x, ...)

\method{light_recode}{default}(x, ...)

\method{light_recode}{light}(x, what, levels, labels, ...)
}
\arguments{
\item{x}{An object of class \code{light}.}

\item{...}{Further arguments passed to \code{factor}.}

\item{what}{Column identifier in \code{x} (not column name) to be recoded, e.g. "type_name", "label_name".}

\item{levels}{Current levels/values of \code{type_name} column (in desired order).}

\item{labels}{New levels of \code{type_name} column in same order as \code{levels}.}
}
\value{
\code{x} with new factor levels of \code{type_name} column.
}
\description{
Recodes factor levels of columns in data slots of an object of class \code{light}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{light}: Recoding factors in data slots of \code{light} object.
}}

\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris, y = "Sepal.Length")
mods <- multiflashlight(list(mod_full, mod_part))
eff <- light_effects(mods, v = "Species")
eff <- light_recode(eff, what = "type_name",
                    levels = c("response", "predicted", "partial dependence", "ale"),
                    labels = c("Observed", "Fitted", "PD", "ALE"))
plot(eff, use = "all")
}
\seealso{
\code{\link{plot.light_effects}}.
}
