% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_ice.R
\name{light_ice}
\alias{light_ice}
\alias{light_ice.default}
\alias{light_ice.flashlight}
\alias{light_ice.multiflashlight}
\title{Individual Conditional Expectation (ICE)}
\usage{
light_ice(x, ...)

\method{light_ice}{default}(x, ...)

\method{light_ice}{flashlight}(
  x,
  v = NULL,
  data = x$data,
  by = x$by,
  evaluate_at = NULL,
  breaks = NULL,
  grid = NULL,
  n_bins = 27L,
  cut_type = c("equal", "quantile"),
  indices = NULL,
  n_max = 20L,
  seed = NULL,
  use_linkinv = TRUE,
  center = c("no", "first", "middle", "last", "mean", "0"),
  ...
)

\method{light_ice}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class "flashlight" or "multiflashlight".}

\item{...}{Further arguments passed to or from other methods.}

\item{v}{The variable name to be profiled.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{evaluate_at}{Vector with values of \code{v} used to evaluate the profile.}

\item{breaks}{Cut breaks for a numeric \code{v}. Used to overwrite automatic
binning via \code{n_bins} and \code{cut_type}. Ignored if \code{v} is not numeric or if \code{grid}
or \code{evaluate_at} are specified.}

\item{grid}{A \code{data.frame} with evaluation grid. For instance, can be generated by
\code{\link[=expand.grid]{expand.grid()}}.}

\item{n_bins}{Approximate number of unique values to evaluate for numeric \code{v}.
Ignored if \code{v} is not numeric or if \code{breaks}, \code{grid} or \code{evaluate_at} are specified.}

\item{cut_type}{Should a numeric \code{v} be cut into "equal" or "quantile" bins?
Ignored if \code{v} is not numeric or if \code{breaks}, \code{grid} or \code{evaluate_at} are specified.}

\item{indices}{A vector of row numbers to consider.}

\item{n_max}{If \code{indices} is not given, maximum number of rows to consider.
Will be randomly picked from \code{data} if necessary.}

\item{seed}{An integer random seed.}

\item{use_linkinv}{Should retransformation function be applied? Default is \code{TRUE}.}

\item{center}{How should curves be centered?
\itemize{
\item Default is "no".
\item Choose "first", "middle", or "last" to 0-center at specific evaluation points.
\item Choose "mean" to center all profiles at the within-group means.
\item Choose "0" to mean-center curves at 0.
}}
}
\value{
An object of class "light_ice" with the following elements:
\itemize{
\item \code{data} A tibble containing the results. Can be used to build fully customized
visualizations. Column names can be controlled by \code{options(flashlight.column_name)}.
\item \code{by} Same as input \code{by}.
\item \code{v} The variable(s) evaluated.
\item \code{center} How centering was done.
}
}
\description{
Generates Individual Conditional Expectation (ICE) profiles.
An ICE profile shows how the prediction of an observation changes if
one or multiple variables are systematically changed across its ranges,
holding all other values fixed (see the reference below for details).
The curves can be centered in order to increase visibility of interaction effects.
}
\details{
There are two ways to specify the variable(s) to be profiled.
\enumerate{
\item Pass the variable name via \code{v} and an optional vector with evaluation points
\code{evaluate_at} (or \code{breaks}). This works for dependence on a single variable.
\item More general: Specify any \code{grid} as a \code{data.frame} with one or
more columns. For instance, it can be generated by a call to \code{\link[=expand.grid]{expand.grid()}}.
}

The minimum required elements in the (multi-)flashlight are "predict_function",
"model", "linkinv" and "data", where the latest can be passed on the fly.

Which rows in \code{data} are profiled? This is specified by \code{indices}.
If not given and \code{n_max} is smaller than the number of rows in \code{data},
then row indices will be sampled randomly from \code{data}.
If the same rows should be used for all flashlights in a multiflashlight,
there are two options: Either pass a \code{seed} or a vector of indices used to select rows.
In both cases, \code{data} should be the same for all flashlights considered.
}
\section{Methods (by class)}{
\itemize{
\item \code{light_ice(default)}: Default method not implemented yet.

\item \code{light_ice(flashlight)}: ICE profiles for a flashlight object.

\item \code{light_ice(multiflashlight)}: ICE profiles for a multiflashlight object.

}}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
fl <- flashlight(model = fit, label = "lm", data = iris)
light_ice(fl, v = "Species")
}
\references{
Goldstein, A. et al. (2015). Peeking inside the black box: Visualizing statistical
learning with plots of individual conditional expectation.
Journal of Computational and Graphical Statistics, 24:1
<doi.org/10.1080/10618600.2014.907095>.
}
\seealso{
\code{\link[=light_profile]{light_profile()}}, \code{\link[=plot.light_ice]{plot.light_ice()}}
}
