% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kenlm.R
\name{KenLM}
\alias{KenLM}
\title{KenLM}
\description{
KenLM

KenLM
}
\examples{

## ------------------------------------------------
## Method `KenLM$new`
## ------------------------------------------------

library(flashlighttext)
sys_file <- function(file) system.file(file, package = "flashlighttext")
read_bin <- function(file, type, size) readBin(sys_file(file), size = size, type, n = 10000)

lexicon <- load_words(sys_file("words.lst")) 
word_dict <- create_word_dict(lexicon) 
lm <- KenLM$new(sys_file("lm.arpa"), word_dict) 
lm_state <- lm$start(FALSE) 
c(lm_state, lm_score) \%<-\% lm$score(lm_state, 0) 
}
\section{Super class}{
\code{\link[flashlighttext:LM]{flashlighttext::LM}} -> \code{KenLM}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{path}}{returns a string}

\item{\code{usrTknDict}}{returns a string vector}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KenLM-new}{\code{KenLM$new()}}
\item \href{#method-KenLM-clone}{\code{KenLM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="LM" data-id="finish"><a href='../../flashlighttext/html/LM.html#method-LM-finish'><code>flashlighttext::LM$finish()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="LM" data-id="score"><a href='../../flashlighttext/html/LM.html#method-LM-score'><code>flashlighttext::LM$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="LM" data-id="start"><a href='../../flashlighttext/html/LM.html#method-LM-start'><code>flashlighttext::LM$start()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KenLM-new"></a>}}
\if{latex}{\out{\hypertarget{method-KenLM-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KenLM$new(path = NULL, usrTknDict = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{a character string representing the path to the binary file 
containing the language model.}

\item{\code{usrTknDict}}{a Dictionary instance populated with user-defined tokens.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the KenLM class.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(flashlighttext)
sys_file <- function(file) system.file(file, package = "flashlighttext")
read_bin <- function(file, type, size) readBin(sys_file(file), size = size, type, n = 10000)

lexicon <- load_words(sys_file("words.lst")) 
word_dict <- create_word_dict(lexicon) 
lm <- KenLM$new(sys_file("lm.arpa"), word_dict) 
lm_state <- lm$start(FALSE) 
c(lm_state, lm_score) \%<-\% lm$score(lm_state, 0) 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KenLM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KenLM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KenLM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
