% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_decoder.R
\name{LexiconDecoderOptions}
\alias{LexiconDecoderOptions}
\title{LexiconDecoderOptions}
\value{
LexiconDecoderOptions
}
\description{
LexiconDecoderOptions

LexiconDecoderOptions
}
\examples{

## ------------------------------------------------
## Method `LexiconDecoderOptions$new`
## ------------------------------------------------

opts <- LexiconDecoderOptions$new(
  beam_size = 2500,
  beam_size_token = 25000,
  beam_threshold = 100.0,
  lm_weight = 2.0,
  word_score = 2.0,
  unk_score = -Inf,
  sil_score = -1,
  log_add = FALSE,
  criterion_type = CriterionTypes$ASG
)

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{beam_size}}{Maximum number of hypothesis we hold after each step}

\item{\code{beam_size_token}}{Maximum number of tokens we consider at each step}

\item{\code{beam_threshold}}{Threshold to prune hypothesis}

\item{\code{lm_weight}}{Weight of lm}

\item{\code{word_score}}{Word insertion score}

\item{\code{unk_score}}{Unknown word insertion score}

\item{\code{sil_score}}{Silence insertion score}

\item{\code{log_add}}{If or not use logadd when merging hypothesis}

\item{\code{criterion_type}}{a CriterionType: "CTC" or "ASG" (see [CriterionTypes])}

\item{\code{ptr}}{set and get the pointer to a LexiconDecoderOptions instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LexiconDecoderOptions-new}{\code{LexiconDecoderOptions$new()}}
\item \href{#method-LexiconDecoderOptions-clone}{\code{LexiconDecoderOptions$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconDecoderOptions-new"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconDecoderOptions-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconDecoderOptions$new(
  beam_size,
  beam_size_token,
  beam_threshold,
  lm_weight,
  word_score,
  unk_score,
  sil_score,
  log_add,
  criterion_type
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beam_size}}{Maximum number of hypothesis we hold after each step}

\item{\code{beam_size_token}}{Maximum number of tokens we consider at each step}

\item{\code{beam_threshold}}{Threshold to prune hypothesis}

\item{\code{lm_weight}}{Weight of lm}

\item{\code{word_score}}{Word insertion score}

\item{\code{unk_score}}{Unknown word insertion score}

\item{\code{sil_score}}{Silence insertion score}

\item{\code{log_add}}{If or not use logadd when merging hypothesis}

\item{\code{criterion_type}}{a CriterionType: "CTC" or "ASG" (see [CriterionTypes])}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{opts <- LexiconDecoderOptions$new(
  beam_size = 2500,
  beam_size_token = 25000,
  beam_threshold = 100.0,
  lm_weight = 2.0,
  word_score = 2.0,
  unk_score = -Inf,
  sil_score = -1,
  log_add = FALSE,
  criterion_type = CriterionTypes$ASG
)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconDecoderOptions-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconDecoderOptions-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconDecoderOptions$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
