% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{add_header_footer}
\alias{add_header_footer}
\alias{add_header}
\alias{add_header_row}
\alias{add_footer_row}
\alias{add_footer_lines}
\alias{add_header_lines}
\alias{add_footer}
\title{Add a row of labels in header or footer part}
\usage{
add_header(x, top = TRUE, ...)

add_header_row(x, top = TRUE, values = character(0),
  colwidths = integer(0))

add_footer_row(x, top = TRUE, values = character(0),
  colwidths = integer(0))

add_footer_lines(x, values = character(0), top = FALSE)

add_header_lines(x, values = character(0), top = TRUE)

add_footer(x, top = TRUE, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{top}{should the row be inserted at the top or the bottom.}

\item{...}{a named list (names are data colnames) of strings
specifying corresponding labels to add.}

\item{values}{values to add as a character vector}

\item{colwidths}{the number of columns to merge in the row for each label}
}
\description{
Add a single row of labels in the flextable's header
or footer part. It can be inserted at the top or the bottom of the part.
}
\examples{
ft <- flextable( head( iris ),
  col_keys = c("Species", "Sepal.Length", "Petal.Length", "Sepal.Width", "Petal.Width") )
ft <- add_header(x = ft, Sepal.Length = "length",
  Sepal.Width = "width", Petal.Length = "length",
  Petal.Width = "width", Species = "Species", top = FALSE )
ft <- add_header(ft, Sepal.Length = "Inches",
  Sepal.Width = "Inches", Petal.Length = "Inches",
  Petal.Width = "Inches", Species = "Species", top = TRUE )
ft <- merge_h(ft, part = "header")
ft <- add_footer(ft, Species = "This is a footnote" )
ft <- merge_at(ft, j = 1:5, part = "footer")
ft
ft <- flextable( head( iris ) )
ft <- add_header_row(ft, values = "blah blah", colwidths = 5)
ft <- add_header_row(ft, values = c("blah", "blah"), colwidths = c(3,2))
ft
ft <- flextable( head( iris ) )
ft <- add_footer_row(ft, values = "blah blah", colwidths = 5)
ft <- add_footer_row(ft, values = c("blah", "blah"), colwidths = c(3,2))
ft
ft <- flextable( head( iris ) )
ft <- add_footer_lines(ft, values = "blah blah")
ft <- add_footer_lines(ft, values = c("blah 1", "blah 2"))
autofit(ft)
ft <- flextable( head( iris ) )
ft <- add_header_lines(ft, values = "blah blah")
ft <- add_header_lines(ft, values = c("blah 1", "blah 2"))
autofit(ft)
}
