% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_flextable.R
\name{merge_h_range}
\alias{merge_h_range}
\title{rowwise merge of a range of columns}
\usage{
merge_h_range(x, i = NULL, j1 = NULL, j2 = NULL, part = "body")
}
\arguments{
\item{x}{\code{flextable} object}

\item{i}{selected rows}

\item{j1, j2}{selected columns that will define the range of columns to merge.}

\item{part}{partname of the table where merge has to be done.}
}
\description{
Merge flextable columns into a single one for each selected rows. All
columns must be consecutive.
}
\examples{
ft <- flextable( head( mtcars ), cwidth = .5 )
ft <- merge_h_range( ft, i =  ~ cyl == 6, j1 = "am", j2 = "carb")
ft
}
\seealso{
Other flextable merging function: 
\code{\link{merge_at}()},
\code{\link{merge_h}()},
\code{\link{merge_none}()},
\code{\link{merge_v}()}
}
\concept{flextable merging function}
