% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{labelizor}
\alias{labelizor}
\title{Change displayed labels}
\usage{
labelizor(x, j = NULL, labels, part = "all")
}
\arguments{
\item{x}{a flextable object}

\item{j}{columns selection}

\item{labels}{a named vector whose names will be used to identify
values to replace and values will be used as labels.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
The function replace text values
in a flextable with labels. The labels are defined
with character named vector.

The function is not written to be fast but to be handy. It does
not replace the values in the underlying dataset but replace the defined
content in the flextable (as defined with \code{\link[=compose]{compose()}}).
}
\examples{
\dontshow{
data.table::setDTthreads(1)
}
z <- summarizor(
  x = CO2[-c(1, 4)],
  by = "Treatment",
  overall_label = "Overall")

ft_1 <- as_flextable(z, separate_with = "variable")

ft_1 <- labelizor(
  x = ft_1, j = c("stat"),
  labels = c(Missing = "Kouign amann")
)

ft_1 <- labelizor(
  x = ft_1, j = c("variable"),
  labels = toupper
)

ft_1
}
\seealso{
\code{\link[=mk_par]{mk_par()}}, \code{\link[=append_chunks]{append_chunks()}}, \code{\link[=prepend_chunks]{prepend_chunks()}}
}
