% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremes.r
\docType{methods}
\name{extremes}
\alias{extremes}
\alias{min,float32-method}
\alias{max,float32-method}
\alias{which.min,float32-method}
\alias{which.max,float32-method}
\title{extremes}
\usage{
\S4method{min}{float32}(x, ..., na.rm = FALSE)

\S4method{max}{float32}(x, ..., na.rm = FALSE)

\S4method{which.min}{float32}(x)

\S4method{which.max}{float32}(x)
}
\arguments{
\item{x}{A float matrix.}

\item{...}{Additional elements (numeric/float vectors/matrices) to sum.}

\item{na.rm}{should NA's be removed?}
}
\value{
A single value.
}
\description{
Min/max values for any combination of float/numeric vector(s)/matri[x|ces].
}
\details{
If there are any elements in \code{...}, all elements in the list will first
be summed in their native precision, then converted to double precision so
they can be combined with \code{base::sum()}.  The final result will be cast
to single precision if \code{...} contains only integer and/or float objects.
Otherwise, the return will be double precision.
}
\examples{
library(float)
x = flrunif(10, 3)

min(x)
min(x, 1)

}
