% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{prepflows}
\alias{prepflows}
\title{Flows Preparation}
\usage{
prepflows(mat, i, j, fij)
}
\arguments{
\item{mat}{A data.frame of flows between origins and destinations: long format
matrix (origins, destinations, flows intensity).}

\item{i}{A character giving the origin field name in mat.}

\item{j}{A character giving the destination field name in mat.}

\item{fij}{A character giving the flow field name in mat.}
}
\value{
A square matrix of flows. Diagonal can be filled or empty depending on data used.
}
\description{
From a long format matrix to a a wide format matrix.
}
\examples{
# Import data
data(nav)
head(nav)
# Prepare data
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")
myflows[1:5,1:5]
}

