% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_exists.R
\name{file_exists}
\alias{file_exists}
\title{Check if a file exists}
\usage{
file_exists(path, data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source))
}
\arguments{
\item{path}{the entire path for the file}

\item{data_source}{the name of the data source, if not set globally. s3, gsc or local}

\item{bucket}{the name of the bucket, if not set globally}
}
\value{
logical. if the file exists or not
}
\description{
Check if a file exists
}
\examples{
# Check with data source local
file_exists(path = "tests/mtcars.csv", data_source = "local")
\dontrun{
# Check with data source GCS
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
file_exists(path = "tests/mtcars.csv")
}
}
