% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero-curve-class.R
\name{interpolate.ZeroCurve}
\alias{interpolate.ZeroCurve}
\title{Interpolate a \code{ZeroCurve}}
\usage{
\method{interpolate}{ZeroCurve}(x, at, ...)
}
\arguments{
\item{x}{a \code{ZeroCurve} object}

\item{at}{a non-negative numeric vector representing the years at which to
interpolate the zero curve}

\item{...}{unused in this method}
}
\value{
a numeric vector of zero rates (continuously compounded, act/365)
}
\description{
There are two key interpolation schemes available in the \code{stats} package:
constant and linear interpolation via \code{\link[stats:approxfun]{stats::approxfun()}} and
spline interpolation via \code{\link[stats:splinefun]{stats::splinefun()}}. The \code{interpolate()} method
is a simple wrapper around these methods that are useful for the purposes
of interpolation financial market objects like zero coupon interest rate
curves.
}
\examples{
zc <- build_zero_curve(LogDFInterpolation())
interpolate(zc, c(1.5, 3))
}
\seealso{
Other interpolate functions: \code{\link{interpolate_dfs}},
  \code{\link{interpolate_zeros}},
  \code{\link{interpolate}}
}
