% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{new_progress_bar}
\alias{new_progress_bar}
\title{Progress bar}
\usage{
new_progress_bar(
  n,
  probs = c(0, 0.25, 0.5, 0.75, 1),
  width = getOption("width", 80),
  symbol = "/",
  ...
)
}
\arguments{
\item{n}{Integer. Number of steps.}

\item{probs}{Double vector. Quantiles where to put marks}

\item{width}{Integer. Width of the bar in characters.}

\item{symbol}{Character. Single character symbol to print each bar.}

\item{...}{Further arguments passed to \code{\link[=cat]{cat()}} such as \code{file} and \code{append}.}
}
\value{
A function that can be included at the interior of a loop to
mark the progress of the loop. It receives a single argument, \code{i},
which is the number of the current step.
}
\description{
A simple progress bar. This function is used in \link{MCMC} when the function has
been called with a single processor.
}
\examples{

x <- new_progress_bar(20)
for (i in 1:20) {
  Sys.sleep(2/20)
  x(i)
}

}
