% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{fm_crs_is_identical}
\alias{fm_crs_is_identical}
\alias{fm_identical_CRS}
\title{Check if two CRS objects are identical}
\usage{
fm_crs_is_identical(crs0, crs1, crsonly = FALSE)

fm_identical_CRS(crs0, crs1, crsonly = FALSE)
}
\arguments{
\item{crs0, crs1}{Two \code{sf::crs}, \code{sp::CRS}, \code{fm_crs} or \code{inla.CRS} objects to be compared.}

\item{crsonly}{logical. If \code{TRUE} and any of \code{crs0} and \code{crs1} are \code{fm_crs} or \code{inla.CRS}
objects, extract and compare only the \code{sf::crs} or \code{sp::CRS} aspects. Default: \code{FALSE}}
}
\value{
logical, indicating if the two crs objects are identical in the
specified sense (see the \code{crsonly} argument)
}
\description{
Check if two CRS objects are identical
}
\section{Functions}{
\itemize{
\item \code{fm_identical_CRS()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
by \code{fm_crs_is_identical()}.

}}
\examples{

crs0 <- crs1 <- fm_crs("longlat_globe")
fm_crs_oblique(crs1) <- c(0, 90)
print(c(
  fm_crs_is_identical(crs0, crs0),
  fm_crs_is_identical(crs0, crs1),
  fm_crs_is_identical(crs0, crs1, crsonly = TRUE)
))
}
\seealso{
\code{\link[=fm_crs]{fm_crs()}}, \link[=fm_crs]{fm_CRS()}, \code{\link[=fm_crs_is_null]{fm_crs_is_null()}}
}
