% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_bary3d}
\alias{fmesher_bary3d}
\title{Barycentric coordinate computation}
\usage{
fmesher_bary3d(mesh_loc, mesh_tv, loc, options)
}
\arguments{
\item{mesh_loc}{numeric matrix; mesh vertex coordinates}

\item{mesh_tv}{3-column integer matrix with 0-based vertex indices for each triangle}

\item{loc}{numeric matrix; coordinates of points to locate in the mesh}

\item{options}{list of triangulation options}
}
\value{
A list with vector \code{index} (tetra index) and matrix \code{where}
(4-column barycentric matrix)
}
\description{
Locate points and compute triangular barycentric coordinates
}
\examples{
m <- fmesher_mesh3d(list(cet_margin = 1),
                    matrix(rnorm(15), 5, 3),
                    matrix(c(0,1,2,3), 1, 4))
b <- fmesher_bary3d(m$loc,
                    m$tv,
                    matrix(c(0.5, 0.5, 0.5), 1, 3),
                    list())
}
