% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmlcdEM.R
\name{fmlcdEM}
\alias{fmlcdEM}
\title{Estimates a Log-Concave Mixture Density}
\usage{
fmlcdEM(X, K = 2, posterior, verbose = 0, maxIter = 50)
}
\arguments{
\item{X}{Matrix of data points (one sample per row)}

\item{K}{Number of latent variables (default: 2)}

\item{posterior}{Matrix with posterior probabilities for class affiliation;
Initialized if not provided using a Gaussian hierarchical clustering.}

\item{verbose}{Int determining the verboseness of the code; 0 = no output
to 3. (default: 0)}

\item{maxIter}{Maximal number of EM iterations. (default: 50)}
}
\value{
Parametrization of the mixture density
  \item{params}{List of length K, where each entry contains the hyperplane for one
  density}
  \item{densEst}{Matrix where each row contains the marginal distribution p(x)}
  \item{tau}{Marginal distribution over the latent variable p(z)}
}
\description{
\code{fmlcdEM} Utilizes the EM approach to obtain a mixture
  of log-concave densities. Utilizes Gaussian hierarchical clustering to
  initilize the posterior probabilities of class affiliation (as proposed
  by the package LogConcDEAD by Cule et al.).
}
