% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsffq_simple_functions.R
\name{quotient}
\alias{quotient}
\title{Food quotient based on hsffq results}
\usage{
quotient(row)
}
\arguments{
\item{row}{contains two components. f1:f85 1-9, representing different
frequency factor responses from the hsffq. These will be stored in columns
2-86 in the row you plug in A value representing participant's age. This
will be stored in column 1 of the input row/}
}
\value{
one value per participant will be returned, representing the food
  quotient for the individual
}
\description{
The quotient function calculates individual level food quotients based on the
individual's answers to the hsffq. This function is only recommended to
calculate at the individual level.
}
\examples{
random_integers <- sample(1:8, 85, replace=TRUE)
vec <- c(6.2, random_integers)
quotient(vec)

rquestionnaire <- function(n, n_food_questions = 85) {
  mat <- matrix(
    sample(1:9, n_food_questions*n, replace = TRUE),
    nrow = n, ncol = n_food_questions
  )
  df <- data.frame( age = round(runif(n, 2, 11), digits = 1) )
  cbind(df, as.data.frame(mat))
}
df <- rquestionnaire(6)

df_results <- data.frame()
for (i in 1:nrow(df)) {
result <- quotient(df[i,])
df_results <- rbind(df_results, result)
}





}
