% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_text.R
\name{format_text}
\alias{format_text}
\title{Format text to match the math font}
\usage{
format_text(x, ..., face = NULL, size = NULL, delim = "$")
}
\arguments{
\item{x}{Vector to be formatted.}

\item{...}{Not used, force later arguments to be used by name.}

\item{face}{Font face. Possible values are "plain", "italic", "bold", "sans",
or "mono". Can also be set as a global option, for example,
\code{options(formatdown.font.face = "sans")} that can be overwritten in an
individual function call.}

\item{size}{Font size. Possible values are "scriptsize", "small" (default),
"normalsize", "large", and "huge". which correspond to selected
LaTeX font size values. Can also be set as a global option, for example,
\code{options(formatdown.font.size = "normalsize")} that can be overwritten
in an individual function call.}

\item{delim}{Character vector (length 1 or 2) defining the delimiters for
marking up inline math. Possible values include \code{"$"} or \code{"\\\\("}, both of
which create appropriate left and right delimiters. Alternatively, left and
right can be defined explicitly in a character vector of length two, e.g.,
\code{c("$", "$")} or \code{c("\\\\(", "\\\\)")}. Custom delimiters can be assigned to
suit the markup environment. Use argument by name.}
}
\value{
A character vector with elements delimited as inline math markup
in plain, italic, or bold font face.
}
\description{
Format a vector as character strings within math delimiters for
rendering in an R Markdown document. The formatting is particularly useful
for formatting text columns in a table in which numerical columns
have been formatted using \code{format_power()} or \code{format_decimal()}.
}
\details{
Given a scalar, vector, or data frame column, \code{format_text()} converts its
argument to a character string of the form \code{"$\\\\mathxx{a}$"} where \code{a}
is the element to be formatted and \verb{\\\\mathxx} determines the font face:
plain type is set by \verb{\\\\mathrm}; italic by \verb{\\\\mathit};
bold by \verb{\\\\mathbf}; sans serif by \verb{\\\\mathsf}; and monospace (typewriter
text) by \verb{\\\\mathtt}. The string includes markup delimiters \verb{$...$} for
rendering as an inline equation in R Markdown or Quarto Markdown document.

Using \code{options()} to assign a value to \code{formatdown.font.face} affects only
that text formatted using \code{format_text()}. However, using \code{options} to assign
\code{formatdown.font.size} affects output formatted by \code{format_text()} and
\code{format_power()}.

Delimiters for inline math markup can be edited if necessary. If the default
argument fails, try using \code{"\\\\("} as an alternative. If using a custom
delimiter to suit the markup environment, be sure to escape all special
symbols.
}
\examples{
# Text vector

# default face = "plain"
x <- air_meas$humid
format_text(x)

# equivalently
format_text(x, face = "plain")

# argument coerced to character string if possible
format_text(x = NA)
format_text(x = c(TRUE, FALSE, TRUE))

# numbers as strings are rendered as-is
format_text(x = c("1.2E-3", "3.4E+0", "5.6E+3"))

# other font faces
format_text(x, face = "italic")
format_text(x, face = "bold")
format_text(x, face = "sans")
format_text(x, face = "mono")

# alternate delimiter
format_text(x, delim = "\\\\(")

}
\seealso{
Other format_*: 
\code{\link{format_decimal}()},
\code{\link{format_power}()},
\code{\link{format_units}()}
}
\concept{format_*}
