% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{spans_to_viscell}
\alias{spans_to_viscell}
\title{Transform vectors of spans (with duplication) to Visibility vector}
\usage{
spans_to_viscell(spans)
}
\arguments{
\item{spans}{numeric. Vector of spans, with each span value repeated
for the cells it covers.}
}
\value{
a logical vector the same length as \code{spans} indicating
whether the contents of a string vector with those spans
}
\description{
Transform vectors of spans (with duplication) to Visibility vector
}
\details{
The values of \code{spans} are assumed to be repeated to such that
each individual position covered by the span has the repeated value.

This means that each block of values in \code{span} must be of a length
at least equal to its value (i.e. two 2s, three 3s, etc).

This function correctly handles cases where two spans of the same size
are next to each other; i.e., a block of four 2s represents two large
cells each of which span two individual cells.
}
\note{
Currently no  checking or  enforcement is done  that the  vector of
spans is valid in the sense described in the Details section above.
}
\examples{

spans_to_viscell(c(2, 2, 2, 2, 1, 3, 3, 3))
}
