% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_Estep.R
\name{fast_Estep}
\alias{fast_Estep}
\title{Fast fitting of the E step}
\usage{
fast_Estep(c, c_lt = 0, delta, alpha, bbeta, pvfm, dist)
}
\arguments{
\item{c}{Vector of length \code{K} of cumulative hazards, i.e. total accumulated hazards within a cluster}

\item{c_lt}{Vector of length \code{K} of cumulative hazard from 0 to the left truncation time}

\item{delta}{Vector of integers of length \code{K} of the number of events for each cluster}

\item{alpha, bbeta}{Parameters of the frailty distribution}

\item{pvfm}{Parameter for the PVF distribution, only matters in that case}

\item{dist}{One of 0 (for gamma), 1 (for stable) or 2 (for PVF)}
}
\value{
A \code{K x 4} matrix where the first column and the second column are the numerators
and the denominators of the frailty fraction, the third is the log-likelihood contribution, and the
last column is the expectation of the squared frailty (only used in calculating the information matrix)
}
\description{
This function calculates the E step in a quicker way, without taking all the derivatives of the Laplace transform.
Such closed form solutions are only available for the gamma distribution (with or without left truncation) and
for the inverse Gaussian distribution (without left truncation).
For a data set with \code{K} clusters,
}
\keyword{internal}
