% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointSurroCopPenal.R
\name{jointSurroCopPenal}
\alias{jointSurroCopPenal}
\title{Fit the one-step Joint frailty-copula model for evaluating a canditate surrogate endpoint}
\usage{
jointSurroCopPenal(data, maxit = 40, indicator.alpha = 1, 
   frail.base = 1, n.knots = 6, LIMparam = 0.001, LIMlogl = 0.001, 
   LIMderiv = 0.001, nb.mc = 1000, nb.gh = 20, nb.gh2 = 32, 
   adaptatif = 0, int.method = 0, nb.iterPGH = 5, true.init.val = 0, 
   thetacopula.init = 1, sigma.ss.init = 0.5, sigma.tt.init = 0.5, 
   sigma.st.init = 0.48, gamma.init = 0.5, alpha.init = 1, 
   betas.init = 0.5, betat.init = 0.5, scale = 1, 
   random.generator = 1, kappa.use = 4, random = 0, 
   random.nb.sim = 0, seed = 0, init.kappa = NULL, ckappa = c(0,0),
   typecopula = 1, nb.decimal = 4, print.times = TRUE, print.iter = FALSE)
}
\arguments{
\item{data}{A \code{\link{data.frame}} containing at least seven variables entitled: 
\itemize{
\item{\code{patientID:} A numeric, that represents the patient's identifier and must be unique;}
\item{\code{trialID:} A numeric, that represents the trial in which each patient was randomized;}
\item{\code{timeS:} The follow-up time associated with the surrogate endpoint;}
\item{\code{statusS:} The event indicator associated with the surrogate endpoint. Normally 
0 = no event, 1 = event;}
\item{\code{timeT:} The follow-up time associated with the true endpoint;}
\item{\code{statusT:} The event indicator associated with the true endpoint. Normally 
0 = no event, 1 = event;}
\item{\code{trt:} The treatment indicator for each patient, with 1 = treated, 0 = untreated.}
}}

\item{maxit}{maximum number of iterations for the Marquardt algorithm.
The default being \code{40}.}

\item{indicator.alpha}{A binary, indicating whether the power's parameter \eqn{\alpha} should 
be estimated (1) or not (0). If \code{0}, \eqn{\alpha} will be set to \code{1} during estimation.
The default is 1.}

\item{frail.base}{A binary, indicating whether the heterogeneity between trial on the baseline 
risk is considered (\code{1}) or not (\code{0}), using 
the shared cluster specific frailties \if{html}{u\out{<sub>i</sub>}} \if{latex}{(\eqn{u_i})}. The default is \code{1}.}

\item{n.knots}{integer giving the number of knots to use. Value required in
the penalized likelihood estimation.  It corresponds to the (n.knots+2)
splines functions for the approximation of the hazard or the survival
functions.  We estimate I or M-splines of order 4. When the user set a
number of knots equals to k (n.knots=k) then the number of interior knots
is (k-2) and the number of splines is (k-2)+order.  Number of knots must be
between 4 and 20. (See \code{\link{frailtyPenal}} for more details).}

\item{LIMparam}{Convergence threshold of the Marquardt algorithm for the
parameters, \if{html}{10\out{<sup>-3</sup>}} \if{latex}{\eqn{10^{-3}}} by default (See \code{\link{frailtyPenal}} for more details).}

\item{LIMlogl}{Convergence threshold of the Marquardt algorithm for the
log-likelihood, \if{html}{10\out{<sup>-3</sup>}} \if{latex}{\eqn{10^{-3}}} by default (See \code{\link{frailtyPenal}} for more details).}

\item{LIMderiv}{Convergence threshold of the Marquardt algorithm for the gradient, 
\if{html}{10\out{<sup>-3</sup>}} \if{latex}{\eqn{10^{-3}}} by default 
(See \code{\link{frailtyPenal}} for more details).}

\item{nb.mc}{Number of samples considered in the Monte-Carlo integration. Required in the event 
\code{int.method} is equals to \code{0}, \code{2} or \code{4}. A value between 500 and 1000 most often gives 
good results. The default is \code{1000}.}

\item{nb.gh}{Number of nodes for the Gaussian-Hermite quadrature. It can
be chosen among 5, 7, 9, 12, 15, 20 and 32. The default is \code{20}. A value greater than or equals to \code{15}
allowed good results in simulation studies}

\item{nb.gh2}{Number of nodes for the Gauss-Hermite quadrature used to re-estimate the model, 
in the event of non-convergence, defined as previously. The default is \code{32}.}

\item{adaptatif}{A binary, indicates whether the pseudo adaptive Gaussian-Hermite quadrature \code{(1)} or the classical
Gaussian-Hermite quadrature \code{(0)} is used. The default is \code{0}.}

\item{int.method}{A numeric, indicates the integration method: \code{0} for Monte carlo, 
\code{1} for Gaussian-Hermite quadrature, \code{3} for Laplace approximation. The default is \code{0}.}

\item{nb.iterPGH}{Number of iterations before the re-estimation of the posterior random effects,
in the event of the two-steps pseudo-adaptive Gaussian-hermite quadrature. If set to \code{0} there is no 
re-estimation". The default is \code{5}.}

\item{true.init.val}{Numerical value. Indicates if the given initial values to parameters \code{(0)} should be considered. 
If set to \code{2}, \eqn{\alpha} and \eqn{\gamma} are initialised using two separed shared frailty model 
(see \code{\link{frailtyPenal}} for more details); 
\if{html}{\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>S</sub></sub>}, \eqn{\sigma}\out{<sup>2</sup><sub>v<sub>T</sub></sub>} and
\eqn{\sigma}\out{<sub>v<sub>ST</sub></sub>}} 
\if{latex}{\eqn{\sigma^2_{v_S}}, \eqn{\sigma^2_{v_T}} and
\eqn{\sigma_{v_{ST}}}}
 are fixed by the user or the default values; 
\eqn{\theta}, \if{html}{\eqn{\beta}\out{<sub>S</sub>} and \eqn{\beta}\out{<sub>T</sub>}} 
\if{latex}{\eqn{\beta_S} and \eqn{\beta_T}} are initialized using a classical joint 
frailty model, considering individual level random effects, with \eqn{\theta} the variance of individual level random effects. 
If the joint frailty model is 
faced to convergence issues, \if{html}{\eqn{\beta}\out{<sub>S</sub>} and \eqn{\beta}\out{<sub>T</sub>}} 
\if{latex}{\eqn{\beta_S} and \eqn{\beta_T}} are initialized using 
two shared frailty models.  In all other scenarios, if the simplified model does not converge,
default given parameters values are used. Initial values for spline's associated parameters 
are fixed to \code{0.5}. The default for this argument is \code{0}.}

\item{thetacopula.init}{Initial values for the copula parameter (\eqn{\theta}), required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{1}.}

\item{sigma.ss.init}{Initial values for \if{latex}{\eqn{\sigma^2_{v_S}}} 
\if{html}{\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>S</sub></sub>}}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{0.5}.}

\item{sigma.tt.init}{Initial values for \if{latex}{\eqn{\sigma^2_{v_T}}} 
\if{html}{\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>T</sub></sub>}}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{0.5}.}

\item{sigma.st.init}{Initial values for \if{latex}{\eqn{\sigma_{v_{ST}}}} 
\if{html}{\eqn{\sigma}\out{<sub>v<sub>ST</sub></sub>}}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{0.48}.}

\item{gamma.init}{Initial values for \eqn{\gamma}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{0.5}.}

\item{alpha.init}{Initial values for \eqn{\alpha}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{1}.}

\item{betas.init}{Initial values for \if{latex}{\eqn{\beta_S}} \if{html}{\eqn{\beta}\out{<sub>S</sub>}}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{0.5}.}

\item{betat.init}{Initial values for \if{latex}{\eqn{\beta_T}} \if{html}{\eqn{\beta}\out{<sub>T</sub>}}, required if \code{true.init.val} 
is set to \code{0} or \code{2}. The default is \code{0.5}.}

\item{scale}{A numeric that allows to rescale (by multiplication) the survival times, to avoid numerical 
problems in the event of some convergence issues. If no change is needed the argument is set to 1, the default value. 
eg: \code{1/365} aims to convert days to years ".}

\item{random.generator}{Random number generator used by the Fortran compiler, 
\code{1} for the intrinsec subroutine \code{Random_number} and \code{2} for the 
subroutine \code{uniran()}. The default is \code{1}. In the event of convergence problem 
with \code{int.method} set to \code{0}, \code{2} or \code{4}, that requires  
integration by Monte-Carlo, user could change the random numbers generator.}

\item{kappa.use}{A numeric, that indicates how to manage the smoothing parameters 
\if{latex}{\code{k_1}} \if{html}{k\out{<sub>1</sub>}} 
and \if{latex}{\code{k_2}} \if{html}{k\out{<sub>2</sub>}} in the event of convergence issues. If it is set to \code{1}, 
the given smoothing parameters or those obtained by cross-validation are used. 
If it is set to \code{3}, the associated smoothing parameters are successively divided by 10, 
in the event of convergence issues until 5 times. If it is set to \code{4}, the management of the
smoothing parameter is as in the event \code{1}, follows by the successive division as described 
in the event \code{3} and preceded by the changing of the number of nodes for the Gauss-Hermite quadrature. 
The default is \code{4}.}

\item{random}{A binary that says if we reset the random number generation with a different environment 
at each call \code{(1)} or not \code{(0)}. If it is set to \code{1}, we use the computer clock 
as seed. In the last case, it is not possible to reproduce the generated datasets". 
The default is \code{0}. Required if \code{random.generator} is set to 1.}

\item{random.nb.sim}{If \code{random} is set to \code{1}, a binary that indicates the number 
of generations that will be made.}

\item{seed}{The seed to use for data (or samples) generation. required if \code{random} is set to \code{0}. 
The default is \code{0}.}

\item{init.kappa}{smoothing parameter used to penalized the log-likelihood. By default (init.kappa = NULL) the values used 
are obtain by cross-validation.}

\item{ckappa}{Vector of two fixed values to add to the smoothing parameters. By default it is set to (0,0). this argument allows
to well manage the smoothing parameters in the event of convergence issues.}

\item{typecopula}{The copula function used, can be 1 for clayton or 2 for Gumbel-Hougaard. The default is \code{1}}

\item{nb.decimal}{Number of decimal required for results presentation.}

\item{print.times}{a logical parameter to print estimation time. Default
is TRUE.}

\item{print.iter}{a logical parameter to print iteration process. Default
is FALSE.}
}
\value{
This function return an object of class jointSurroPenal with elements :

   \item{EPS}{A vector containing the obtained convergence thresholds with the Marquardt algorithm,  
    for the parameters, the log-likelihood and for the gradient;}
   \item{b}{\if{latex}{A vector containing estimates for the splines parameter's; elements of the
    lower triangular matrix (L) from the Cholesky decomposition such that \eqn{\Sigma = LL^T}, with \eqn{\Sigma} 
    the covariance of the random effects \eqn{(v_{S_i},v_{T_i})}; the coefficient \eqn{\alpha} 
    (if \code{indicator.alpha} is set to \code{1}); the satandard error of the random effect \eqn{u_i}; the logarithm
    of the copula parameter (\eqn{\theta}) if the Clayton copula function is considered, or 
    the squared root of \eqn{\theta} if the Gumbel copula is considered. The last two parameters represent 
    the regression coefficients \eqn{\beta_S} and \eqn{\beta_T};}
    \if{html}{A vector containing estimates for the splines parameter's; elements of the
    lower triangular matrix (L) from the Cholesky decomposition such that \eqn{\Sigma} = LL\out{<sup>T</sup>}, with \eqn{\Sigma} 
    the covariance of the random effects (\out{v<sub>S<sub>i</sub></sub>},\out{v<sub>T<sub>i</sub></sub>}); 
    the coefficient \eqn{\alpha} (if \code{indicator.alpha} is set to \code{1}); the satandard error 
    of the random effect \code{u}\out{<sub>i</sub>}; the logarithm
    of the copula parameter (\eqn{\theta}) if the Clayton copula function is considered, or 
    the squared root of \eqn{\theta} if the Gumbel copula is considered. The last two parameters represent 
    the regression coefficients \eqn{\beta}\out{<sub>S</sub>} and \eqn{\beta}\out{<sub>T</sub>};}}
    \item{varH}{The variance matrix of all parameters in \code{b} (before positivity constraint transformation 
   for the variance of the measurement error, for which the delta method is used);}
   \item{varHIH}{The robust estimation of the variance matrix of all parameters in \code{b};}
   \item{loglikPenal}{The complete marginal penalized log-likelihood;}
   \item{LCV}{the approximated likelihood cross-validation criterion in the semiparametric case (with \code{H}
    minus the converged Hessian matrix, and \code{l(.)} the full log-likelihood).
    \if{html}{
    {\figure{lcv.png}{options: width="50\%"}}}
    \if{latex}{\deqn{LCV = \frac{1}{n}(trace(H^{-1}_{pl}H) - l(.))};}}
   \item{xS}{vector of times for surrogate endpoint where both survival and hazard function are estimated. 
   By default seq(0,max(time),length=99), where time is the vector of survival times;}
   \item{lamS}{array (dim = 3) of hazard estimates and confidence bands, for surrogate endpoint;}
   \item{survS}{array (dim = 3) of baseline survival estimates and confidence bands, for surrogate endpoint;}
   \item{xT}{vector of times for true endpoint where both survival and hazard function are estimated. 
   By default seq(0, max(time), length = 99), where time is the vector of survival times;}
   \item{lamT}{array (dim = 3) of hazard estimates and confidence bands, for true endpoint;}
   \item{survT}{array (dim = 3) of baseline survival estimates and confidence bands, for true endpoint;}
   \item{n.iter}{number of iterations needed to converge;}
   \item{theta}{Estimate for \eqn{\theta};}
   \item{gamma}{Estimate for \eqn{\gamma};}
   \item{alpha}{Estimate for \eqn{\alpha};}
   \item{zeta}{A value equals to \code{1}, no really use in this function;}
   \item{sigma.s}{Estimate for \if{latex}{\eqn{\sigma^2_{v_S}}}\if{html}{\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>S</sub></sub>}};}
   \item{sigma.t}{Estimate for \if{latex}{\eqn{\sigma^2_{v_T}}}\if{html}{\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>T</sub></sub>}};}
   \item{sigma.st}{Estimate for \if{latex}{\eqn{\sigma_{v_{ST}}}} \if{html}{\eqn{\sigma}\out{<sub>v<sub>ST</sub></sub>}};}
   \item{beta.s}{Estimate for \if{latex}{\eqn{\beta_S}} \if{html}{\eqn{\beta}\out{<sub>S</sub>}};}
   \item{beta.t}{Estimate for \if{latex}{\eqn{\beta_T}} \if{html}{\eqn{\beta}\out{<sub>T</sub>}};}
   \item{ui}{A binary, that indicates if the heterogeneity between trial on the baseline risk 
   has been Considered (\code{1}), using the shared cluster specific frailties \if{latex}{(\eqn{u_i})}
   \if{html}{(\code{u}\out{<sub>i</sub>})}, 
   or not (\code{0});}
   \item{ktau}{The Kendall's \eqn{\tau} with the correspondant 95  \eqn{\%} CI obtained from the delta-method;}
   \item{R2.boot}{The \if{latex}{\eqn{R^2_{trial}}}
   \if{html}{\code{R}\out{<sup>2</sup><sub>trial</sub>}}
    with the correspondant 95 \eqn{\%} CI obtained from the parametric bootstrap;}
   \item{Coefficients}{The estimates with the corresponding standard errors and the 95 \eqn{\%} CI}
   \item{kappa}{Positive smoothing parameters used for convergence. These values could be different to initial 
   values if \code{kappa.use} is set to \code{3} or \code{4};}
   \item{scale}{The value used to rescale the survival times}
   \item{data}{The dataset used in the model}
   \item{varcov.Sigma}{Covariance matrix of the estimates of \if{latex}{(\eqn{\sigma^2_{v_S}},\eqn{\sigma^2_{v_T}},\eqn{\sigma_{v_{ST}}})}
   \if{html}{the estimates of (\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>S</sub></sub>},\eqn{\sigma}\out{<sup>2</sup><sub>v<sub>T</sub></sub>}, 
   \eqn{\sigma}\out{<sub>v<sub>ST</sub></sub>})} obtained from the delta-method}
   \item{parameter}{List of all arguments used in the model}
   \item{type.joint}{A code \code{3} that represents the joint frailty-copula model. This output is used in other functions}
}
\description{
{
\if{html}{\bold{Joint Frailty-Copula model for Surrogacy definition} 

Fit the one-step Joint frailty-copula surrogate model for the evaluation of a canditate surrogate endpoint, 
with different integration methods on the random effects, using a semiparametric penalized 
likelihood estimation. This approach extends that of Burzykowski \code{et al.} (2001) by 
including in the bivariate copula model the random effects treatment-by-trial interaction. 

Assume S\out{<sub>ij</sub>} and \out{T<sub>ij</sub>} the failure times associated respectively 
with the surrogate and the true endpoints, for subject \code{j(j = 1,..., n}\out{<sub>i</sub>}\code{)} belonging to 
the trial \code{i (i = 1,..., G)}.

Let \out{<strong>v</strong>}\out{<sub>i</sub>} = (u\out{<sub>i</sub>}, 
v\out{<sub>S<sub>i</sub></sub>}, v\out{<sub>T<sub>i</sub></sub>}) be the vector of trial 
level random effects; \out{<b>Z</b><sub>S,ij</sub> = (Z<sub>Sij1</sub>, ..., Z<sub>Sijp</sub>)<sup>'</sup>} 
and \out{<b>Z</b><sub>T,ij</sub> = (Z<sub>Tij1</sub>, ..., Z<sub>Tijp</sub>)<sup>'</sup>} 
be covariates associated with \out{S<sub>ij</sub>} and \out{T<sub>ij</sub>}.  
The joint frailty-copula model is defined as follows:

{\figure{jointSurvCop1.png}{options: width="100\%"}}

where

{\figure{jointSurvCop3.png}{options: width="100\%"}}

and the conditional survival functions are given by

{\figure{jointSurvCop2.png}{options: width="100\%"}}

in which

u\out{<sub>i</sub>} \out{&#126;} \eqn{N}(0,\eqn{\gamma}),
u\out{<sub>i</sub>} \out{&#8869;} v\out{<sub>S<sub>i</sub></sub>}, u\out{<sub>i</sub>} \out{&#8869;} v\out{<sub>T<sub>i</sub></sub>};
(v\out{<sub>S<sub>i</sub></sub>}, v\out{<sub>T<sub>i</sub></sub>})\out{<sup>T</sup>} \out{&#126;} \eqn{N}(0,\eqn{\Sigma}\out{<sub>v</sub>})

with

{\figure{surromodel2.png}{options: width="100\%"}}


In this model, \eqn{\lambda}\out{<sub>0s</sub>}(x) is the baseline hazard function associated with the 
surrogate endpoint and \eqn{\beta}\out{<sub>S</sub>} the fixed effects (or log-hazard ratio) corresponding 
to the covariates \out{<b>Z</b><sub>S,ij</sub>}; 
\eqn{\lambda}\out{<sub>0T</sub>}(x) is the baseline hazard function associated with the true endpoint 
and \eqn{\beta}\out{<sub>T</sub>} the fixed treatment effects corresponding 
to the covariates \out{<b>Z</b><sub>T,ij</sub>}. The copula model serves to consider dependence between 
the surrogate and true endpoints at the individual level. In the copula model, \eqn{\theta} is the copula 
parameter used to quantify the strength of association. u\out{<sub>i</sub>} is a shared frailty effect associated 
with the baseline hazard function that serve to take into account the heterogeneity between trials 
of the baseline hazard function, associated with the fact that we have several trials in this 
meta-analytical design. The power parameter \eqn{\alpha} distinguishes 
trial-level heterogeneity between the surrogate and the true endpoint. 
v\out{<sub>S<sub>i</sub></sub>} and v\out{<sub>T<sub>i</sub></sub>} are two correlated random effects treatment-by-trial interactions. 
\eqn{Z}\out{<sub>Sij1</sub>} or \eqn{Z}\out{<sub>Tij1</sub>} represents the treatment arm to which the patient has been randomized.

For simplicity, we focus on the Clayton and Gumbel-Hougaard copula functions. In Clayton's 
model, the copula function has the form

{\figure{jointSurvCop5.png}{options: width="100\%"}}

and in Gumbel's model, the copula function has the form

{\figure{jointSurvCop6.png}{options: width="100\%"}}


\bold{Surrogacy evaluation}

We propose to base validation of a candidate surrogate endpoint on Kendall's \eqn{\tau} at the individual level and 
coefficient of determination at the trial level, as in the classical approach (Burzykowski \code{et al.}, 2001). 
The formulations are given below.

\bold{Individual-level surrogacy}

From the proposed model, according to the copula function, it can be shown that Kendall's \eqn{\tau}
is defined as :

{\figure{jointSurvCop4.png}{options: width="100\%"}}
       
 
 where \eqn{\theta} is the copula parameter. Kendall's \eqn{\tau} is the difference between the probability of 
 concordance and the probability of discordance of two realizations of \eqn{S}\out{<sub>ij</sub>} and \eqn{T}\out{<sub>ij</sub>}. 
 It belongs to the interval [-1,1] and assumes a zero value when \eqn{S}\out{<sub>ij</sub>} and \eqn{T}\out{<sub>ij</sub>} are 
 independent.
 
 \bold{Trial-level surrogacy}
 
 The key motivation for validating a surrogate endpoint is to be able to predict the effect 
 of treatment on the true endpoint, based on the observed effect of treatment on the 
 surrogate endpoint. As shown by Buyse \emph{et al.} (2000), the coefficenient of 
 determination obtains from the covariance matrix \eqn{\Sigma}\out{<sub>v</sub>} of the random effects 
 treatment-by-trial interaction can be used to evaluate underlined prediction, and 
 therefore as surrogacy evaluation measurement at trial-level. It is defined by: 
 
 {\figure{surromodel4.png}{options: width="100\%"}}
 
 The SEs of \eqn{R}\out{<sub>trial</sub>}\out{<sup>2</sup>} and \eqn{\tau} are calculated using the Delta-method. We also propose 
 \eqn{R}\out{<sub>trial</sub>}\out{<sup>2</sup>} and 95\% CI computed using the parametric bootstrap. The use of delta-method 
 can lead to confidence limits violating the [0,1], as noted by 
 (Burzykowski \emph{et al.}, 2001). However, using other methods would not significantly alter
 the findings of the surrogacy assessment 
 }
 \if{latex}{\bold{Joint Frailty-Copula model for Surrogacy definition} 

Fit the one-step Joint surrogate model for the evaluation of a canditate surrogate endpoint, 
with different integration methods on the random effects, using a semiparametric penalized 
likelihood estimation. This approach extends that of Burzykowski \code{et al.} (2001) by 
including in the bivariate copula model the random effects treatment-by-trial interaction.

Assume \eqn{S_{ij}} and \eqn{T_{ij}} the failure times associated respectively 
with the surrogate and the true endpoints, for subject \code{j} (\eqn{j=1,\ldots, n_i}) 
belonging to the trial \eqn{i (i=1, \ldots, G)}.

Let \eqn{\mathbf{v}_i = (u_i,v_{Si},v_{Ti})} be the vector of trial 
level random effects; \eqn{\mathbf{Z}_{S,ij} = (Z_{Sij1}, \cdots, Z_{Sijp})^{'}} and 
\eqn{\mathbf{Z}_{T,ij} = (Z_{Tij1}, \cdots, Z_{Tijp})^{'}} 
be covariates associated with \eqn{S_{ij}} and \eqn{T_{ij}} 
The joint frailty-copula model is defined as follows:
 

\deqn{\begin{array}{ll}
  \bar{F}(s_{ij},t_{ij}|\mathbf{Z}_{S,ij},\mathbf{Z}_{T,ij},\mathbf{v}_i) & 
  = P(S_{ij} > s_{ij}, T_{ij} > t_{ij}|\mathbf{Z}_{S,ij}, \mathbf{Z}_{T,ij},\mathbf{v}_i) \\
  & = \varphi_\theta [\varphi^{-1}_\theta(\bar{F}(s_{ij}|\mathbf{Z}_{S,ij},u_i, v_{Si})) 
  +  \varphi^{-1}_\theta(\bar{F}(t_{ij}|\mathbf{Z}_{T,ij},u_i, v_{Ti}))]\\
\end{array} }

where,

\eqn{\varphi_\theta} : \eqn{[0,\infty) \rightarrow [0, 1]} the generator of a parametric 
Archimedean copula family

and the conditional survival functions are given by

\deqn{\bar{F}_{S,ij}(s_{ij}|\mathbf{Z}_{S,ij},u_i, v_{Si})= \exp \bigg\{ - \int_0^{s_{ij}} \lambda _{0S}(x) 
\exp\bigg(u_i + v_{Si} Z_{ij1}+ \boldsymbol \beta_S \mathbf{Z}_{S,ij}\bigg) dx  \bigg\}}

\deqn{\bar{F}_{T,ij}(t_{ij}|\mathbf{Z}_{T,ij},u_i, v_{Ti})= \exp \bigg\{ - \int_0^{t_{ij}} \lambda _{0T}(x) 
\exp\bigg(\alpha u_i + v_{Ti} Z_{ij1}+ \boldsymbol \beta_T \mathbf{Z}_{T,ij}\bigg) dx  \bigg\}}

in which 

\deqn{u_i \sim N (0,\gamma), u_i \perp v_{S_i}, u_i \perp v_{T_i}; (v_{S_i},v_{T_i})^{T}\sim\mathcal{N}\left({{0}},
\Sigma_{v}\right)}
 
with

\deqn{\Sigma_{v}=\left(
                      \begin{array}{cc} 
                         \sigma^2_{v_S}  &  \sigma_{v_{ST}} \\ 
                         \sigma_{v_{ST}} &  \sigma^2_{v_T}
                      \end{array}
                 \right)}

In this model, \eqn{\lambda_{0S}(t)} is the baseline hazard function associated with the 
surrogate endpoint and \eqn{\beta_S} the fixed effects (or log-hazard ratio) corresponding
to the covariates \eqn{\mathbf{Z}_{S,ij}}; 
\eqn{\lambda_{0T}(t)} is the baseline hazard function associated with the true endpoint 
and \eqn{\beta_T} the fixed effects corresponding to the covariates \eqn{\mathbf{Z}_{T,ij}}.
The copula model serves to consider dependence between 
the surrogate and true endpoints at the individual level. In the copula model, \eqn{\theta} is the copula 
parameter used to quantify the strength of association. \eqn{u_i} is a shared frailty effect associated 
with the baseline hazard function that serve to take into account the heterogeneity between trials 
of the baseline hazard function, associated with the fact that we have several trials in this 
meta-analytical design. The power parameter \eqn{\alpha} distinguishes 
trial-level heterogeneity between the surrogate and the true endpoint. 
\eqn{v_{S_i}} and \eqn{v_{T_i}} are two correlated random effects treatment-by-trial interactions. 
\eqn{Z_{Sij1}} or \eqn{Z_{Tij1}} represents the treatment arm to which the patient has been randomized.

For simplicity, we focus on the Clayton and Gumbel-Hougaard copula functions. In Clayton's 
model, the copula function has the form

\deqn{\varphi_\theta(s) = (1 + \theta s)^{-1/\theta}, \hspace{0.25cm} \theta > 0}

and in Gumbel's model, the copula function has the form

\deqn{\varphi_\theta(s) = \exp{[-s^{1/(1+\theta)}]}, \hspace{0.25cm} \theta \geq 0}

\bold{Surrogacy evaluation}

We proposed to base validation of a candidate surrogate endpoint on Kendall's \eqn{\tau} at the individual level and 
coefficient of determination at the trial level, as in the classical approach (Burzykowski \code{et al.}, 2001). 
The formulations are given below.

\bold{Individual-level surrogacy}

From the proposed model, according to the copula function, it can be shown that Kendall's \eqn{\tau}
is defined as:

\eqn{\tau = \frac{\theta}{\theta + 2}} for Clayton copula and \eqn{\tau = \frac{\theta}{\theta + 1}}
for Gumbel copula.
       
 
 where \eqn{\theta} is the copula parameter. Kendall's \eqn{\tau} is the difference between the probability of 
 concordance and the probability of discordance of two realizations of \eqn{S_{ij}} and \eqn{T_{ij}}. 
 It belongs to the interval [-1,1] and assumes a zero value when \eqn{S_{ij}} and \eqn{T_{ij}} are 
 independent.
 
 \bold{Trial-level surrogacy}
 
 The key motivation for validating a surrogate endpoint is to be able to predict the effect 
 of treatment on the true endpoint, based on the observed effect of treatment on the 
 surrogate endpoint. As shown by Buyse \emph{et al.} (2000), the coefficenient of 
 determination obtains from the covariance matrix \eqn{\Sigma_v} of the random effects 
 treatment-by-trial interaction can be used to evaluate underlined prediction, and 
 therefore as surrogacy evaluation measurement at trial-level. It is defined by: 
 
 \deqn{ R^2_{trial}=\frac{\sigma^2_{v_{ST}}}{\sigma^2_{v_S}\sigma^2_{v_T}}
 }
 
 The SEs of \eqn{R^2_{trial}} and \eqn{\tau} are calculated using the Delta-method. We also propose 
 \eqn{R^2_{trial}} and 95\% CI computed using the parametric bootstrap. The use of delta-method 
 can lead to confidence limits violating the [0,1], as noted by 
 (Burzykowski \emph{et al.}, 2001). However, using other methods would not significantly alter
 the findings of the surrogacy assessment 
 }

}
}
\details{
{
The estimated parameter are obtained using the robust Marquardt algorithm
(Marquardt, 1963) which is a combination between a Newton-Raphson algorithm
and a steepest descent algorithm. The iterations are stopped when the
difference between two consecutive log-likelihoods was small (<
\if{html}{10\out{<sup>-3</sup>}} \if{latex}{\eqn{10^{-3}}}), the estimated 
coefficients were stable (consecutive
values (< \if{html}{10\out{<sup>-3</sup>}} \if{latex}{\eqn{10^{-3}}})), and the gradient 
small enough (< \if{html}{10\out{<sup>-3</sup>}} \if{latex}{\eqn{10^{-3}}}), by default.
Cubic M-splines of order 4 are used for the hazard function, and I-splines 
(integrated M-splines) are used for the cumulative hazard function.

The inverse of the Hessian matrix is the variance estimator and to deal
with the positivity constraint of the variance component and the spline
coefficients, a squared transformation is used and the standard errors are
computed by the \eqn{\Delta}-method (Knight & Xekalaki, 2000). The smooth
parameter can be chosen by maximizing a likelihood cross validation
criterion (Joly and other, 1998). 

We proposed based on the joint surrogate model a new definition 
of the Kendall's \eqn{\tau}. Moreover, distinct numerical integration methods are available to approximate the 
integrals in the marginal log-likelihood.

\bold{Non-convergence case management procedure}

Special attention must be given to initializing model parameters, the choice of the number of 
spline knots, the smoothing parameters and the number of quadrature points to solve convergence 
issues. We first initialized parameters using the user's desired strategy, as specified 
by the option \code{true.init.val}. When numerical or convergence problems are encountered, 
with \code{kappa.use} set to \code{4}, the model is fitted again using a combination of the following strategies: 
vary the number of quadrature point (\code{nb.gh} to \code{nb.gh2} or \code{nb.gh2} to \code{nb.gh})
in the event of the use of the Gaussian Hermite quadrature integration (see \code{int.method}); 
divided or multiplied the smoothing parameters (\if{latex}{\code{k_1}} \if{html}{k\out{<sub>1</sub>}}, 
\if{latex}{\code{k_2}} \if{html}{k\out{<sub>2</sub>}}) by 10 or 100 according to 
their preceding values, or used parameter vectors obtained during the last iteration (with a 
modification of the number of quadrature points and smoothing parameters). Using this strategy, 
we usually obtained during simulation the rejection rate less than 3\%. A sensitivity analysis 
was conducted without this strategy, and similar results were obtained on the converged samples, 
with about a 23\% rejection rate. 
}
}
\examples{

\dontrun{
# Data from the advanced ovarian cancer randomized clinical trials.
data(dataOvarian)
joint.surro.Gumbel <- jointSurroCopPenal(data = dataOvarian, int.method = 0, 
      n.knots = 8, maxit = 50, kappa.use = 4, nb.mc = 1000, typecopula = 2, 
      print.iter = T, scale = 1/365)
      
summary(joint.surro.Gumbel)

joint.surro.Clayton <- jointSurroCopPenal(data = dataOvarian, int.method = 0, 
      n.knots = 8, maxit = 50, kappa.use = 4, nb.mc = 1000, typecopula = 1, 
      print.iter = T, scale = 1/365) 

summary(joint.surro.Clayton)
}

}
\references{
Burzykowski, T., Molenberghs, G., Buyse, M., Geys, H., and Renard, D. (2001). Validation
of surrogate end points in multiple randomized clinical trials with failure time end points. 
Journal of the Royal Statistical Society: Series C (Applied Statistics) 50, 405-422.

Buyse, M., Molenberghs, G., Burzykowski, T., Renard, D., and Geys, H. (2000). The validation
of surrogate endpoints in meta-analyses of randomized experiments. Biostatistics 1, 49-67

Sofeu, C. L., Emura, T., and Rondeau, V. (2019). One-step validation method for surrogate 
endpoints using data from multiple randomized cancer clinical trials with failure-time endpoints. 
Statistics in Medicine 38, 2928-2942. 

R. B. Nelsen. An introduction to Copulas. Springer, 2006

Prenen, L., Braekers, R., and Duchateau, L. (2017). Extending the archimedean copula methodology 
to model multivariate survival data grouped in clusters of variable size. Journal of the Royal 
Statistical Society: Series B (Statistical Methodology) 79, 483-505.

Sofeu, C. L., Emura, T., and Rondeau, V. (2020). A joint frailty-copula model for meta-analytic 
validation of failure time surrogate endpoints in clinical trials. \code{Under review}
}
\seealso{
\code{\link{jointSurrCopSimul}}, \code{\link{summary.jointSurroPenal}}, \code{\link{jointSurroPenal}}, \code{\link{jointSurroPenalSimul}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
