% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/franc.R
\encoding{utf8}
\name{franc}
\alias{franc}
\title{Detect the language of a string}
\usage{
franc(text, min_speakers = 1e+06, whitelist = NULL, blacklist = NULL,
  min_length = 10, max_length = 2048)
}
\arguments{
\item{text}{A string constant. Should be at least \code{min_length}
characters long, this is 10 characters by default.
Only the first \code{max_length} characters are used (2048 by
default), to make the detection reasonably fast.}

\item{min_speakers}{Languages with at least this many speakers are
checked. By default this is one million. Set it to zero to
include all languages known by franc. See also \code{\link{speakers}}.}

\item{whitelist}{List of three letter language codes to check against.}

\item{blacklist}{List of three letter language codes not to check
againts.}

\item{min_length}{Minimum number of characters required in the text.}

\item{max_length}{Maximum number of characters used from the text.
By default only the first 2048 characters are used.}
}
\value{
A three letter ISO-639-3 language code, the detected
  language of the text. \code{"und"} is returned for too short input.
}
\description{
Detect the language of a string
}
\examples{
## afr
franc("Alle menslike wesens word vry")

## nno
franc("Alle mennesker er født frie og")

## Too short, und
franc("the")

## You can change what’s too short (default: 10), sco
franc("the", min_length = 3)
}
\seealso{
\code{\link{franc_all}} for scores against many languages,
  \code{\link{speakers}}.
}

