% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_curv.R
\name{read.fs.curv}
\alias{read.fs.curv}
\title{Read file in FreeSurfer curv format}
\usage{
read.fs.curv(filepath, format = "auto", with_header = FALSE)
}
\arguments{
\item{filepath}{string. Full path to the input curv file. Note: gzipped binary curv files are supported and gz binary format is assumed if the filepath ends with ".gz".}

\item{format}{one of 'auto', 'asc', 'bin', 'nii' or 'txt'. The format to assume. If set to 'auto' (the default), binary format will be used unless the filepath ends with '.asc' or '.txt'. The latter is just one float value per line in a text file.}

\item{with_header}{logical, whether to return named list with 'header' and 'data' parts. Only valid with FreeSurfer binary curv format.}
}
\value{
data vector of floats. The brain morphometry data, one value per vertex.
}
\description{
Read vertex-wise brain morphometry data from a file in FreeSurfer 'curv' format. Both the binary and ASCII versions are supported.
   For a subject (MRI image pre-processed with FreeSurfer) named 'bert', an example file would be 'bert/surf/lh.thickness', which contains n values. Each value represents the cortical thickness at the respective vertex in the brain surface mesh of bert.
}
\examples{
    curvfile = system.file("extdata", "lh.thickness",
                            package = "freesurferformats", mustWork = TRUE);
    ct = read.fs.curv(curvfile);
    cat(sprintf("Read data for \%d vertices. Values: min=\%f, mean=\%f, max=\%f.\n",
                            length(ct), min(ct), mean(ct), max(ct)));

}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.ni1}()},
\code{\link{write.fs.morph.ni2}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight.asc}()},
\code{\link{write.fs.weight}()}
}
\concept{morphometry functions}
